package cn.gtmap.landtax.entity;

import org.hibernate.annotations.CacheConcurrencyStrategy;

import javax.persistence.*;
import java.util.Date;

/**
 * 记录核查项目中被标记了不需要创建核查任务的信息
 * Created by zhouzhiwei on 2015-11-17.
 */
@Entity
@org.hibernate.annotations.Cache(usage = CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@Table(name = "S_SJ_SIGNHCXM")
public class SSjSignhcxm {
    /**
     * 主键ID
     */
    @Id
    private String signId;

    /**
     * 核查项目任务ID
     * 对应核查项目的主键ID
     */
    @Column
    private String rwId;

    /**
     * 项目类型
     * 对应核查项目的Hcxmlx代码
     */
    @Column
    private String xmlx;

    /**
     * 状态
     * 1表示标记为不需要创建核查项目
     * 0表示不需要创建核查项目的标记已被撤销，需要创建核查项目
     */
    @Column
    private String zt;

    /**
     * 操作的用户名称
     */
    @Column
    private String username;

    /**
     * 操作的用户id
     */
    @Column
    private String userid;

    /**
     * 操作的日期
     */
    @Column
    private Date rq;

    /**
     * 备注
     * 原因说明
     */
    @Column
    private String bz;

    public String getSignId() {
        return signId;
    }

    public void setSignId(String signId) {
        this.signId = signId;
    }

    public String getRwId() {
        return rwId;
    }

    public void setRwId(String rwId) {
        this.rwId = rwId;
    }

    public String getXmlx() {
        return xmlx;
    }

    public void setXmlx(String xmlx) {
        this.xmlx = xmlx;
    }

    public String getZt() {
        return zt;
    }

    public void setZt(String zt) {
        this.zt = zt;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public Date getRq() {
        return rq;
    }

    public void setRq(Date rq) {
        this.rq = rq;
    }

    public String getBz() {
        return bz;
    }

    public void setBz(String bz) {
        this.bz = bz;
    }
}
