<@com.html title="政务公开查询" import="jquery,common,bui">
<div class="newsContent">
    <div>
        <div class="container">
            <div class="row-fluid">
                <#if type='tddj'||type='bjcx'>
                    <div id="form1" class="well form-inline">
                        <#if type='tddj'>
                            <span class="control-text">权利人：</span>
                            <input class="control-text search-query" placeholder="权利人" name="qlr" type="text">

                            <span class="control-text">土地坐落：</span>
                            <input class="control-text search-query" placeholder="土地坐落" name="zl" type="text">

                            <span class="control-text">土地证号：</span>
                            <input class="control-text search-query" placeholder="土地证号" name="tdzh" type="text">
                        <#elseif type='bjcx'>
                            <span class="control-text">项目名称：</span>
                            <input class="control-text search-query" placeholder="项目名称" name="xmmc" type="text">
                        </#if>
                        <button id="queryBtn" class="button button-primary">
                            <i class="icon-search icon-white"></i>查&nbsp询
                        </button>
                    </div>
                </#if>
            </div>
        </div>


        <div class="baseTable" id="baseTable">
        </div>
        <div id="pagination" class="pagination SimplePagination">
            <ul>
                <li><a>第一页</a></li>
                <li class="NotClickable"><a href="#" style="border-radius:0px;">« 上一页</a></li>
                <li class="active"><a href="#">1</a></li>
                <li><a href="#">2</a></li>
                <li><a href="#">3</a></li>
                <li><a href="#">4</a></li>
                <li><a href="#">下一页 »</a></li>
                <li><a>最后一页</a></li>
            </ul>
        </div>
    </div>
</div>
<script>

    var type = '${type!}';
    var url = "${base}/search/pageJson";
    var defaultRows = 5;
    function parseToTable(json) {
        $.getJSON("${base}/static/json/table.json", function (data) {
            var tableHeads = data[type];
            var html = "<table class='table table-bordered' cellspacing='0'><thead><tr>";
            for (var j in tableHeads) {
                html += "<th"
                if(tableHeads[j].hasOwnProperty("width"))
                    html += " width='"+tableHeads[j].width+"'>";
                else
                    html += ">";
                html +=tableHeads[j].title + "</th>"
            }
            html = html + "</tr></thead><tbody>";

            for (var i = 0; i < json.length; i++) {
                html = html + "<tr>";
                for (var j in tableHeads) {
                    var tmpstr = json[i][tableHeads[j].name] != null ? json[i][tableHeads[j].name] : "";
                    if(tableHeads[j].hasOwnProperty('render'))
                        html +="<td>"+eval(tableHeads[j].render+"('"+tmpstr+"')")+"</td>";
                    else
                        html += "<td title=" + tmpstr + ">" + tmpstr + "</td>";
                }
                html += "</tr>";
            }
            html += "</tbody>";
            $("#baseTable").html(html);
        });
    }

    function renderGwcxOperation(value){
        return "<a href='${base}/downLoad/downLoadFwzw?dispatch_id=" + value + "'>查看正文</a>";
    }

    function rebuild(data) {
        $("#baseTable").empty();
        if (data.content != null && data.content.length > 0) {
            parseToTable(data.content)
            parsePagination(data);
            initpagectrl(data.number,data.totalPages,data.size);
        }
    }

    function parsePagination(json) {
        var currentpage = (json.number + 1) * 1.0;
        var firstpage = currentpage * 1.0 - 5;
        var lastpage = currentpage * 1.0 + 5;
        if (firstpage < 1) {
            firstpage = 1;
        }
        if (lastpage > json.totalPages) {
            lastpage = json.totalPages + 1;
        }
        var html = "<ul><li><a>第一页</a></li>";
        if (json.firstPage) {
            html += "<li><span>«  上一页</span></li>"
        } else {
            html += "<li><a href='#' style='border-radius:0px;'>«  上一页</a></li>"
        }
        for (var i = firstpage; i < lastpage; i++) {
            html += "<li";
            if (i == currentpage) {
                html = html + " class='active'"
            }
            html += "><a href='#'>" + i + "</a></li>";
        }
        if (json.lastPage) {
            html += "<li><span>下一页 »</span></li>";
        } else {
            html += "<li><a href=#>下一页 »</a></li>";
        }
        html +="<li><a>最后一页</a></li></ul>";
        $("#pagination").html(html);
    }


    function initpagectrl(number,totalPages,size) {	//增加页脚控制信息
        $("#pagination>ul>li>a").click(function () {
            var page;
            var text =$(this).text();
            if (text == "第一页") {
                page = 0;
            }
            else if (text == "最后一页") {
                page = totalPages-1;
            }
            else if (text == "«  上一页") {
                page = number-1
            }
            else if (text == "下一页 »") {
                page = number + 1
            }
            else {
                page = (text * 1.0 - 1);
            }
            var param = getPagedParametes();
            param.page = page;
            postAjaxData(url,param);
        })
    }
    function postAjaxData(url,param){
        $.post(url,param, function (data) {
            rebuild(data);
        });
    }

    $(function () {
        postAjaxData(url,{"type":type,"rows":defaultRows});
        $('#queryBtn').click(function(){
            postAjaxData(url,getPagedParametes());
        });
    })

    function getPagedParametes(){
        var param = $('#form1').serializeObject();
        param.type=type;
        param.rows = defaultRows;
        return param;
    }

</script>
</@com.html>