<@com.dyhtml title="网上办件平台" import="jquery,bui,bootstrap" userName="${userName!}">
<!--  面包屑  -->
<div class="row-fluid">
    <div class="span12 breadcrumbBox">
        <ul class="breadcrumb">
            <li><i class="icon-home"></i>当前位置：</li>
            <li><a href="${base}/indexDy">主页</a> <span class="divider">/</span></li>
            <li class="active">网上办件</li>
        </ul>
    </div>
</div>

<!--end  面包屑  -->
<!--  内容部分  -->
<div class="middlesBg">
    <div class="middles">
        <!--  注册  -->
        <div class="boderBg Registration">
            <form class="form-base" id="form1" name="form1" method="POST">
                <input id="userId" name="userId" value="${vo.userId!}" type="hidden">

                <div class="row-fluid">
                    <div class="span11 offset1 Lab1">
                        <h2>用户注册<span>User Registration</span></h2>
                    </div>
                </div>

                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>姓名：</label></div>
                    <div class="span9">
                        <input type="text" id="loginName" name="loginName" value="${vo.loginName!}" data-rules="{required:true}">
                        <span class='x-icon x-icon-mini x-icon-normal'>!</span><label class='x-field-error-text'>提示：请填写真实姓名，否则不予登陆（姓名为已取得房产证权利人名）</label>
                    </div>
                </div>
                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>密码：</label></div>
                    <div class="span9">
                        <input type="password" id="password" name="password" value="${vo.password!}" data-rules="{required:true}">
                    </div>
                </div>


                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>确认密码：</label></div>
                    <div class="span9">
                        <input type="password" id="repassword" value="" data-rules="{required:true,equalTo:'#password'}">
                    </div>
                </div>

                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>证件类型：</label></div>
                    <div class="span9">
                        <select name="credentialsType" id="credentialsType" data-rules="{required:true}" value="${vo.credentialsType!}">
                            <#list sfzmtypeList as item>
                                <option value="${item.id}" >${item.text}</option>
                            </#list>
                        </select>
                    </div>
                </div>

                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>证件号码：</label></div>
                    <div class="span9">
                        <input type="text" id="credentialsId" name="credentialsId" value="${vo.credentialsId!}" data-rules="{required:true,regexp:[/(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/,'身份证输入不合法']}">
                    </div>
                </div>


                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>手机号码：</label></div>
                    <div class="span9"><input id="mobile" name="mobile" type="text" value="${vo.mobile!}" data-rules="{required:true,regexp:[/^\d+$/,'这里不是有效的数字']}"></div>
                </div>

                <div class="row-fluid">
                    <div class="span3"><label><s>*</s>现居：</label></div>
                    <div class="span9">
                        <input type="text" id="address" name="address" value="${vo.address!}" data-rules="{required:true}">
                    </div>
                </div>

                <div class="row-fluid ">
                    <div class="span9 offset3"><button type="submit" class="button button-primary ">提交</button></div>

                </div>

            </form>
        </div>
    </div>
</div>
<!--end  内容部分  -->

<script>

    BUI.use('bui/form',function(Form){
        formcheckobj = new Form.HForm({
            srcNode : '#form1',
            defaultChildCfg : {
                validEvent : 'blur' //失去焦点验证
            },
            validators : {
                'loginName' : function(value){ //读取input的表单字段 name
                    if(value!=null && value!=""){
                        $.post("${base}/user/checkLoginName","loginName="+value, function (data) {
                            if(data!=null && data!="" && data=="true"){
                                $("#checkLoginName").html("<span class='x-icon x-icon-mini x-icon-error'>!</span><label class='x-field-error-text'>登录名重复，请选择其他登录名！</label>");
                                 return;
                            }else{
                                $("#checkLoginName").html("");
                            }
                        });
                    }
                }
            },
            submitType : 'ajax',
            action:'${base}/user/save',
            autoRender:true,
            callback : function(data){
                if(data=="true"){
                    alert('注册成功！');
                    location.href="${base}/logout";
                }else{
                    alert(data);
                }
            }
        }).render();
    });
</script>
<!--end  注册  -->

</@com.dyhtml>