/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.web;

import cn.gtmap.landiss.entity.TblWssb;
import cn.gtmap.landiss.service.WssbService;
import com.gtis.common.util.UUIDGenerator;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wssb"})
public class WssbController {
    @Autowired
    WssbService wssbService;

    @RequestMapping(value={""})
    public String index(Model model, String sbId) {
        TblWssb tblWssb = null;
        tblWssb = StringUtils.isBlank((String)sbId) ? new TblWssb() : this.wssbService.getWssb(sbId);
        model.addAttribute("vo", (Object)tblWssb);
        return "/landiss/web/wssqInput";
    }

    @RequestMapping(value={"/record"})
    public String openRecord(Model model, String sbId) {
        TblWssb vo;
        if (StringUtils.isBlank((String)sbId)) {
            sbId = UUIDGenerator.generate();
        }
        if ((vo = this.wssbService.getWssb(sbId)) == null) {
            vo = new TblWssb();
            vo.setSbId(sbId);
        }
        model.addAttribute("vo", (Object)vo);
        model.addAttribute("sbId", (Object)vo.getSbId());
        return "/landiss/web/wssbInput";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public String saveRecord(TblWssb tblWssb) {
        this.wssbService.saveWssb(tblWssb);
        return "true";
    }
}

