/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.web;

import cn.gtmap.landiss.entity.TblUser;
import cn.gtmap.landiss.model.Select2Vo;
import cn.gtmap.landiss.service.UserService;
import cn.gtmap.landiss.util.CommonUtil;
import cn.gtmap.landiss.util.MD5;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController {
    @Autowired
    UserService userService;
    @Resource
    @Qualifier(value="sfzmtypeList")
    private List<Select2Vo> sfzmtypeList;

    @RequestMapping(value={""})
    public String registerUser(Model model, String userId) {
        TblUser vo;
        if (StringUtils.isBlank((String)userId)) {
            userId = UUIDGenerator.generate();
        }
        if ((vo = this.userService.getUser(userId)) == null) {
            vo = new TblUser();
            vo.setUserId(userId);
        }
        String currentUserName = CommonUtil.getCurrentUserName();
        model.addAttribute("userName", (Object)currentUserName);
        model.addAttribute("vo", (Object)vo);
        model.addAttribute("tsId", (Object)vo.getUserId());
        model.addAttribute("sfzmtypeList", (Object)this.sfzmtypeList);
        return "/landiss/web/danyang/registration";
    }

    @RequestMapping(value={"list"})
    public String listAllUsers(Model model) {
        return "";
    }

    @RequestMapping(value={"checkLoginName"})
    @ResponseBody
    public String checkLoginName(Model model, String loginName) {
        if (StringUtils.isNotBlank((String)loginName)) {
            TblUser vo = this.userService.getUserByLoginName(loginName);
            if (vo != null) {
                return "true";
            }
            return "false";
        }
        return "false";
    }

    @RequestMapping(value={"pageJson"})
    @ResponseBody
    public Page<TblUser> getPagedJson(Model model, Pageable pageable) {
        ArrayList queryConditionList = new ArrayList();
        return this.userService.findUsers(queryConditionList, pageable);
    }

    @RequestMapping(value={"save"})
    @ResponseBody
    public Object saveRegisterUser(Model model, TblUser tblUser) {
        if (tblUser != null) {
            tblUser.setEnabled(Integer.valueOf(1));
            tblUser.setUserName(tblUser.getLoginName());
            tblUser.setPassword(MD5.GetMD5Code((String)tblUser.getPassword()));
        }
        this.userService.saveUser(tblUser);
        return "true";
    }
}

