/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.web;

import cn.gtmap.landiss.model.QueryParam;
import cn.gtmap.landiss.service.SearchService;
import cn.gtmap.landiss.util.QueryCondition;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search"})
public class SearchController {
    public static final String TDDJ_TYPE = "tddj";
    public static final String BJCX_TYPE = "bjcx";
    public static final String GWCX_TYPE = "gwcx";
    @Autowired
    SearchService searchService;

    @RequestMapping(value={""})
    public String index(Model model, String type) {
        if (StringUtils.isBlank((String)type)) {
            type = BJCX_TYPE;
        }
        model.addAttribute("type", (Object)type);
        return "landiss/web/search";
    }

    @RequestMapping(value={"pageJson"})
    @ResponseBody
    public <T> Page<T> getPagedJson(Model model, Pageable page, String type, QueryParam queryParam) {
        Page pageResult = null;
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = null;
        if (StringUtils.isNotBlank((String)queryParam.getQlr())) {
            queryCondition = new QueryCondition("qlr like '%" + queryParam.getQlr() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getZl())) {
            queryCondition = new QueryCondition("zl like '%" + queryParam.getZl() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getTdzh())) {
            queryCondition = new QueryCondition("tdzh like '%" + queryParam.getTdzh() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getXmmc())) {
            queryCondition = new QueryCondition("workflow_instance_name like '%" + queryParam.getXmmc() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isBlank((String)type) || type.equals(BJCX_TYPE)) {
            pageResult = this.searchService.findWorkflow(queryConditionList, page);
        } else if (type.equals(TDDJ_TYPE)) {
            pageResult = this.searchService.findTddj(queryConditionList, page);
        } else if (type.equals(GWCX_TYPE)) {
            pageResult = this.searchService.findOffice(queryConditionList, page);
        }
        return pageResult;
    }
}

