/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.web;

import cn.gtmap.landiss.model.QueryParam;
import cn.gtmap.landiss.service.ExpDataService;
import cn.gtmap.landiss.service.impl.FreeMarkConfigService;
import cn.gtmap.landiss.util.CommonUtil;
import cn.gtmap.landiss.util.QueryCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/expData"})
public class ExpDataController {
    public static final String WSSB_TYPE = "wssb";
    public static final String TSJY_TYPE = "tsjy";
    public static final String WSSB_TBL = "/WEB-INF/views/landiss/jsontbl/TBL_WSSB.ftl";
    public static final String TSJY_TBL = "/WEB-INF/views/landiss/jsontbl/TBL_TSJY.ftl";
    public static final String MESSAGE = "\u672a\u67e5\u5230\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01";
    @Autowired
    private FreeMarkConfigService freeMarkConfigService;
    @Autowired
    ExpDataService expDataService;

    @RequestMapping(value={""})
    public String index(Model model, String type) {
        if (StringUtils.isBlank((String)type)) {
            type = WSSB_TYPE;
        }
        model.addAttribute("type", (Object)type);
        return "landiss/web/expdata";
    }

    @RequestMapping(value={"pageJson"})
    @ResponseBody
    public <T> Page<T> getPagedJson(Model model, Pageable page, String type, QueryParam queryParam) {
        Page pageResult = null;
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = null;
        if (StringUtils.isNotBlank((String)queryParam.getSbrLxr())) {
            queryCondition = new QueryCondition("sbrLxr like '%" + queryParam.getSbrLxr() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getSbrZjhm())) {
            queryCondition = new QueryCondition("sbrZjhm like '%" + queryParam.getSbrZjhm() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getTsLyr())) {
            queryCondition = new QueryCondition("tsLyr like '%" + queryParam.getTsLyr() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getTsLxdh())) {
            queryCondition = new QueryCondition("tsLxdh like '%" + queryParam.getTsLxdh() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isBlank((String)type) || type.equals(WSSB_TYPE)) {
            pageResult = this.expDataService.findWssb(queryConditionList, page);
        } else if (type.equals(TSJY_TYPE)) {
            pageResult = this.expDataService.findTsjy(queryConditionList, page);
        }
        return pageResult;
    }

    @RequestMapping(value={"expDataToFile"})
    @ResponseBody
    public String expDataToFile(Model model, String type, QueryParam queryParam) {
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        List listWssb = new ArrayList();
        List listTsjy = new ArrayList();
        String JsonStr = "";
        String msg = "";
        QueryCondition queryCondition = null;
        if (StringUtils.isNotBlank((String)queryParam.getSbrLxr())) {
            queryCondition = new QueryCondition("sbrLxr like '%" + queryParam.getSbrLxr() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getSbrZjhm())) {
            queryCondition = new QueryCondition("sbrZjhm like '%" + queryParam.getSbrZjhm() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getTsLyr())) {
            queryCondition = new QueryCondition("tsLyr like '%" + queryParam.getTsLyr() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getTsLxdh())) {
            queryCondition = new QueryCondition("tsLxdh like '%" + queryParam.getTsLxdh() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isBlank((String)type) || type.equals(WSSB_TYPE)) {
            listWssb = this.expDataService.findWssbList(queryConditionList);
        } else if (type.equals(TSJY_TYPE)) {
            listTsjy = this.expDataService.findTsjyList(queryConditionList);
        }
        HashMap<String, Object> Entitymap = new HashMap<String, Object>();
        Entitymap.put("updatemothod", "insert");
        if (listWssb != null && listWssb.size() > 0) {
            Entitymap.put("DataList", listWssb);
            JsonStr = this.freeMarkConfigService.getTblJsonData(Entitymap, WSSB_TBL);
            if (StringUtils.isNotBlank((String)JsonStr)) {
                msg = CommonUtil.writeStrToFile((String)JsonStr, (String)WSSB_TYPE.toUpperCase());
            }
        } else if (listTsjy != null && listTsjy.size() > 0) {
            Entitymap.put("DataList", listTsjy);
            JsonStr = this.freeMarkConfigService.getTblJsonData(Entitymap, TSJY_TBL);
            if (StringUtils.isNotBlank((String)JsonStr)) {
                msg = CommonUtil.writeStrToFile((String)JsonStr, (String)TSJY_TYPE.toUpperCase());
            }
        } else {
            msg = MESSAGE;
        }
        return msg;
    }
}

