/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.web;

import cn.gtmap.landiss.entity.TblFgzhf;
import cn.gtmap.landiss.entity.TblProject;
import cn.gtmap.landiss.model.QueryParam;
import cn.gtmap.landiss.model.Select2Vo;
import cn.gtmap.landiss.service.BusinessService;
import cn.gtmap.landiss.util.CommonUtil;
import cn.gtmap.landiss.util.QueryCondition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/businesssqList"})
public class BusinessSqListController {
    @Autowired
    BusinessService businessService;
    private static final String type_shz = "\u5ba1\u6838\u4e2d";
    @Resource
    @Qualifier(value="sfzmtypeList")
    private List<Select2Vo> sfzmtypeList;

    @RequestMapping(value={""})
    public String usersqList(Model model, String type) {
        if (StringUtils.isBlank((String)type)) {
            type = "usersq";
        }
        model.addAttribute("type", (Object)type);
        String currentUserName = CommonUtil.getCurrentUserName();
        Boolean isshUser = CommonUtil.checkLoginNameForMenu((String)currentUserName);
        if (isshUser.booleanValue()) {
            model.addAttribute("isshUser", (Object)"true");
        }
        model.addAttribute("userName", (Object)currentUserName);
        return "landiss/web/danyang/business_usersqList";
    }

    @RequestMapping(value={"detailBussiness"})
    public String getdetailBussiness(Model model, String proId, String tfid) {
        String currentUserName = CommonUtil.getCurrentUserName();
        Boolean isshUser = CommonUtil.checkLoginNameForMenu((String)currentUserName);
        if (isshUser.booleanValue()) {
            model.addAttribute("isshUser", (Object)"true");
        }
        model.addAttribute("userName", (Object)currentUserName);
        if (StringUtils.isNotBlank((String)proId)) {
            TblProject tblProject = this.businessService.getTblProject(proId);
            if (tblProject != null) {
                model.addAttribute("status", (Object)tblProject.getStatus());
                model.addAttribute("remark", (Object)tblProject.getRemark());
                TblFgzhf tblFgzhf = this.businessService.getFgzhfByProId(proId);
                if (tblFgzhf != null) {
                    model.addAttribute("tfid", (Object)tblFgzhf.getTfId());
                }
                return "landiss/web/danyang/business_sl";
            }
        } else if (StringUtils.isNotBlank((String)tfid)) {
            model.addAttribute("status", (Object)type_shz);
            model.addAttribute("tfid", (Object)tfid);
            return "landiss/web/danyang/business_sl";
        }
        return "landiss/web/danyang/business_usersqList";
    }

    @RequestMapping(value={"pageJson"})
    @ResponseBody
    public <T> Page<T> getPagedJson(Model model, Pageable page, String type, QueryParam queryParam) {
        String currentUserName;
        Page pageResult = null;
        ArrayList<QueryCondition> queryConditionList = new ArrayList<QueryCondition>();
        QueryCondition queryCondition = null;
        if (StringUtils.isNotBlank((String)queryParam.getQlr())) {
            queryCondition = new QueryCondition("qlr like '%" + queryParam.getQlr() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getZl())) {
            queryCondition = new QueryCondition("zl like '%" + queryParam.getZl() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getTdzh())) {
            queryCondition = new QueryCondition("tdzh like '%" + queryParam.getTdzh() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)queryParam.getXmmc())) {
            queryCondition = new QueryCondition("workflow_instance_name like '%" + queryParam.getXmmc() + "%'");
            queryConditionList.add(queryCondition);
        }
        if (StringUtils.isNotBlank((String)(currentUserName = CommonUtil.getCurrentUserName()))) {
            queryCondition = new QueryCondition("creater = '" + currentUserName + "'");
            queryConditionList.add(queryCondition);
        }
        pageResult = this.businessService.findTblProject(queryConditionList, page);
        return pageResult;
    }
}

