/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.support.spring;

import java.util.Iterator;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PageableMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static String SIZE_PARAMETER = "rows";
    private PageableHandlerMethodArgumentResolver pageableArgumentResolver = new PageableHandlerMethodArgumentResolver();

    public PageableHandlerMethodArgumentResolver getPageableArgumentResolver() {
        return this.pageableArgumentResolver;
    }

    public void setPageableArgumentResolver(PageableHandlerMethodArgumentResolver pageableArgumentResolver) {
        this.pageableArgumentResolver = pageableArgumentResolver;
    }

    public boolean supportsParameter(MethodParameter methodParameter) {
        return Pageable.class.equals((Object)methodParameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        this.resolveSizeArgument(nativeWebRequest);
        return this.pageableArgumentResolver.resolveArgument(methodParameter, modelAndViewContainer, nativeWebRequest, webDataBinderFactory);
    }

    private void resolveSizeArgument(NativeWebRequest webRequest) {
        Iterator parameterNames = webRequest.getParameterNames();
        while (parameterNames.hasNext()) {
            String name = (String)parameterNames.next();
            if (!name.equals(SIZE_PARAMETER)) continue;
            this.pageableArgumentResolver.setSizeParameterName(SIZE_PARAMETER);
            break;
        }
    }
}

