/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.support.message;

import cn.gtmap.landiss.ex.ExceptionCode;
import cn.gtmap.landiss.support.message.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageUtils {
    private static final String EXCEPTION_MSG_PREFIX = "exception.";
    private static final String INFORMATION_MSG_PREFIX = "information.";
    private static MessageService messageService;

    public static String getExceptionMsg(ExceptionCode exceptionCode) {
        return messageService.getMessage(EXCEPTION_MSG_PREFIX + exceptionCode.toString());
    }

    public static String getExceptionMsg(ExceptionCode exceptionCode, Object[] args) {
        return messageService.getMessage(EXCEPTION_MSG_PREFIX + exceptionCode.toString(), args);
    }

    public static String getInfoMsg(String key) {
        return messageService.getMessage(INFORMATION_MSG_PREFIX + key);
    }

    @Autowired
    public void setMessageService(MessageService messageService) {
        MessageUtils.messageService = messageService;
    }
}

