/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.support.jpa;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;

public class EntityManagerFactoryBean
extends LocalContainerEntityManagerFactoryBean {
    public static final Set<String> AUTOS = Sets.newHashSet((Object[])new String[]{"update", "create", "create-drop"});
    private DatabasePopulator databasePopulator;

    public void setDatabasePopulator(DatabasePopulator databasePopulator) {
        this.databasePopulator = databasePopulator;
    }

    protected void postProcessEntityManagerFactory(EntityManagerFactory emf, PersistenceUnitInfo pui) {
        String hbm2ddlAuto = (String)this.getJpaPropertyMap().get("hibernate.hbm2ddl.auto");
        if (hbm2ddlAuto != null && AUTOS.contains(hbm2ddlAuto) && this.databasePopulator != null) {
            DatabasePopulatorUtils.execute((DatabasePopulator)this.databasePopulator, (DataSource)this.getDataSource());
        }
        super.postProcessEntityManagerFactory(emf, pui);
    }
}

