/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.service.impl;

import cn.gtmap.landiss.entity.QTblUser;
import cn.gtmap.landiss.entity.TblUser;
import cn.gtmap.landiss.service.UserService;
import cn.gtmap.landiss.support.jpa.BaseRepository;
import cn.gtmap.landiss.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    BaseRepository baseRepository;

    @Transactional(readOnly=true)
    public TblUser getUser(String userId) {
        return (TblUser)this.baseRepository.get(TblUser.class, (Object)userId);
    }

    @Transactional(readOnly=true)
    public TblUser getUserByLoginName(String loginName) {
        QTblUser qTblUser = QTblUser.tblUser;
        try {
            JPAQuery query = new JPAQuery(this.baseRepository.getEntityManager());
            return (TblUser)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{qTblUser})).where(new Predicate[]{qTblUser.loginName.eq((Object)loginName)})).uniqueResult((Expression)qTblUser);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Transactional
    public void saveUser(TblUser user) {
        if (StringUtils.isNotBlank((String)user.getUserId())) {
            TblUser temp = this.getUser(user.getUserId());
            if (temp == null) {
                this.baseRepository.save((Object)user);
            } else {
                this.baseRepository.update((Object)user);
            }
        } else {
            user.setUserId(UUIDGenerator.generate());
            this.baseRepository.save((Object)user);
        }
    }

    @Transactional
    public void deleteUser(String userId) {
        this.baseRepository.delete(TblUser.class, (Object)userId);
    }

    @Transactional(readOnly=true)
    public Page<TblUser> findUsers(List<QueryCondition> queryConditionList, Pageable pageable) {
        return this.baseRepository.find(TblUser.class, queryConditionList, null, pageable);
    }
}

