/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.service.impl;

import cn.gtmap.landiss.entity.TblUser;
import cn.gtmap.landiss.ex.AppException;
import cn.gtmap.landiss.ex.ExceptionCode;
import cn.gtmap.landiss.service.UserService;
import cn.gtmap.landiss.support.security.UserInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="userDetailsService")
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Autowired
    UserService userService;

    public UserDetails loadUserByUsername(String s) throws UsernameNotFoundException, DataAccessException {
        TblUser user = this.userService.getUserByLoginName(s);
        if (user == null) {
            throw new AppException(ExceptionCode.USER_NOT_FOUND);
        }
        if (user.getEnabled() != 1) {
            throw new AppException(ExceptionCode.USER_DISABLED);
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(user.getUserId());
        userInfo.setUsername(user.getLoginName());
        if (user.getIsAdmin() != null && user.getIsAdmin() == 1) {
            userInfo.setAdmin(true);
        }
        userInfo.setPassword(user.getPassword());
        return userInfo;
    }
}

