/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.service.impl;

import cn.gtmap.landiss.entity.TblOffice;
import cn.gtmap.landiss.entity.TblTddj;
import cn.gtmap.landiss.entity.TblWorkflow;
import cn.gtmap.landiss.service.ImpDataFromFileService;
import cn.gtmap.landiss.support.jpa.BaseRepository;
import cn.gtmap.landiss.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImpDataFromFileServiceImpl
implements ImpDataFromFileService {
    private FileSystemResource impfilePath;
    @Autowired
    BaseRepository baseRepository;

    @Transactional
    public void saveTblTddj(TblTddj tddjVo) {
        if (StringUtils.isNotBlank((String)tddjVo.getProjectid())) {
            TblTddj temp = (TblTddj)this.baseRepository.get(TblTddj.class, (Object)tddjVo.getProjectid());
            if (temp == null) {
                this.baseRepository.save((Object)tddjVo);
            } else {
                this.baseRepository.update((Object)tddjVo);
            }
        }
    }

    @Transactional
    public void saveTblWorkFlow(TblWorkflow platformVo) {
        if (StringUtils.isNotBlank((String)platformVo.getWorkflow_instance_id())) {
            TblWorkflow temp = (TblWorkflow)this.baseRepository.get(TblWorkflow.class, (Object)platformVo.getWorkflow_instance_id());
            if (temp == null) {
                this.baseRepository.save((Object)platformVo);
            } else {
                this.baseRepository.update((Object)platformVo);
            }
        }
    }

    @Transactional
    public void saveTblOffice(TblOffice tblOffice) {
        if (StringUtils.isNotBlank((String)tblOffice.getDispatch_id())) {
            TblOffice temp = (TblOffice)this.baseRepository.get(TblOffice.class, (Object)tblOffice.getDispatch_id());
            if (temp == null) {
                this.baseRepository.save((Object)tblOffice);
            } else {
                this.baseRepository.update((Object)tblOffice);
            }
        }
    }

    public TblOffice getTblOffice(String dispatch_id) {
        TblOffice temp = new TblOffice();
        if (StringUtils.isNotBlank((String)dispatch_id)) {
            temp = (TblOffice)this.baseRepository.get(TblOffice.class, (Object)dispatch_id);
        }
        return temp;
    }

    public List<TblTddj> getTblTddjList() {
        ArrayList<TblTddj> VoFileList = new ArrayList<TblTddj>();
        List JsonFileList = CommonUtil.getJsonFile((String)"TBL_TDDJ.json", (FileSystemResource)this.impfilePath);
        if (JsonFileList != null && JsonFileList.size() > 0) {
            for (int i = 0; i < JsonFileList.size(); ++i) {
                Map tddjjsonMap = (Map)JsonFileList.get(i);
                Map tempMap = (Map)tddjjsonMap.get("value");
                List valueMap = (List)tempMap.get("col");
                for (int j = 0; j < valueMap.size(); ++j) {
                    TblTddj tddjVo = new TblTddj();
                    Map valueMaptemp = (Map)valueMap.get(j);
                    CommonUtil.mapBind((Map)valueMaptemp, (Object)tddjVo);
                    VoFileList.add(tddjVo);
                }
            }
        }
        return VoFileList;
    }

    public List<TblOffice> getTblOfficeList() {
        ArrayList<TblOffice> VoFileList = new ArrayList<TblOffice>();
        List JsonFileList = CommonUtil.getJsonFile((String)"TBL_OFFICE.json", (FileSystemResource)this.impfilePath);
        if (JsonFileList != null && JsonFileList.size() > 0) {
            for (int i = 0; i < JsonFileList.size(); ++i) {
                Map tddjjsonMap = (Map)JsonFileList.get(i);
                Map tempMap = (Map)tddjjsonMap.get("value");
                List valueMap = (List)tempMap.get("col");
                for (int j = 0; j < valueMap.size(); ++j) {
                    TblOffice tblOffice = new TblOffice();
                    Map valueMaptemp = (Map)valueMap.get(j);
                    CommonUtil.mapBind((Map)valueMaptemp, (Object)tblOffice);
                    VoFileList.add(tblOffice);
                }
            }
        }
        return VoFileList;
    }

    public List<TblWorkflow> getTblWorkflowList() {
        ArrayList<TblWorkflow> VoFileList = new ArrayList<TblWorkflow>();
        List JsonFileList = CommonUtil.getJsonFile((String)"TBL_WORKFLOW.json", (FileSystemResource)this.impfilePath);
        if (JsonFileList != null && JsonFileList.size() > 0) {
            for (int i = 0; i < JsonFileList.size(); ++i) {
                Map tddjjsonMap = (Map)JsonFileList.get(i);
                Map tempMap = (Map)tddjjsonMap.get("value");
                List valueMap = (List)tempMap.get("col");
                for (int j = 0; j < valueMap.size(); ++j) {
                    TblWorkflow tblWorkflow = new TblWorkflow();
                    Map valueMaptemp = (Map)valueMap.get(j);
                    CommonUtil.mapBind((Map)valueMaptemp, (Object)tblWorkflow);
                    VoFileList.add(tblWorkflow);
                }
            }
        }
        return VoFileList;
    }

    public Resource getImpfilePath() {
        return this.impfilePath;
    }

    public void setImpfilePath(FileSystemResource impfilePath) {
        this.impfilePath = impfilePath;
    }
}

