/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.landiss.service.impl;

import cn.gtmap.landiss.entity.QTblFgzhf;
import cn.gtmap.landiss.entity.TblFgzhf;
import cn.gtmap.landiss.entity.TblProject;
import cn.gtmap.landiss.service.BusinessService;
import cn.gtmap.landiss.support.jpa.BaseRepository;
import cn.gtmap.landiss.util.QueryCondition;
import com.gtis.common.util.UUIDGenerator;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusinessServiceImpl
implements BusinessService {
    @Autowired
    BaseRepository baseRepository;

    @Transactional(readOnly=true)
    public TblFgzhf getFgzhf(String tfid) {
        return (TblFgzhf)this.baseRepository.get(TblFgzhf.class, (Object)tfid);
    }

    @Transactional(readOnly=true)
    public TblFgzhf getFgzhfByProId(String proid) {
        QTblFgzhf tbl = QTblFgzhf.tblFgzhf;
        try {
            JPAQuery query = new JPAQuery(this.baseRepository.getEntityManager());
            return (TblFgzhf)((JPQLQuery)((JPQLQuery)query.from(new EntityPath[]{tbl})).where(new Predicate[]{tbl.tblProject.proId.eq((Object)proid)})).uniqueResult((Expression)tbl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Transactional(readOnly=true)
    public TblProject getTblProject(String proid) {
        return (TblProject)this.baseRepository.get(TblProject.class, (Object)proid);
    }

    @Transactional
    public void saveFgzhf(TblFgzhf tblFgzhf) {
        if (StringUtils.isNotBlank((String)tblFgzhf.getTfId())) {
            TblFgzhf temp = this.getFgzhf(tblFgzhf.getTfId());
            if (temp == null) {
                this.baseRepository.save((Object)tblFgzhf);
            } else {
                this.baseRepository.update((Object)tblFgzhf);
            }
        } else {
            tblFgzhf.setTfId(UUIDGenerator.generate());
            this.baseRepository.save((Object)tblFgzhf);
        }
    }

    @Transactional
    public void saveTblProject(TblProject tblProject) {
        if (StringUtils.isNotBlank((String)tblProject.getProId())) {
            TblProject temp = this.getTblProject(tblProject.getProId());
            if (temp == null) {
                this.baseRepository.save((Object)tblProject);
            } else {
                this.baseRepository.update((Object)tblProject);
            }
        } else {
            tblProject.setProId(UUIDGenerator.generate());
            this.baseRepository.save((Object)tblProject);
        }
    }

    @Transactional
    public void deleteFgzhf(String tfid) {
        this.baseRepository.delete(TblFgzhf.class, (Object)tfid);
    }

    @Transactional(readOnly=true)
    public Page<TblProject> findTblProject(List<QueryCondition> queryConditionList, Pageable pageable) {
        return this.baseRepository.find(TblProject.class, queryConditionList, "order by updateTime Desc", pageable);
    }
}

