<@com.html title="外出申请" import="layui,common,font,main,sign"/>
<body class="gtmap">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
</style>
<div class="gt-container">
    <form class="layui-form" id="outgoingForm">
    <#if view=="">
        <@toolbar show="save,print" />
    <#else>
    </#if>
        <input type="hidden" id="id" name="id" value="${outgoing.id!}"/>
        <input type="hidden" id="outType" name="outType" value="${outgoing.outType!}"/>
        <input type="hidden" id="view" name="view" value="${view!}"/>
        <div class="gt-content">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    外出申请
                </div>
            </div>
            <table class="layui-table gt-special-table table-border">
                <tr>
                    <td class="gt-td-title">申请人</td>
                    <td class="pd0" colspan="2" >
                        <input class="layui-input" type="text" id="peopleName" name="peopleName" value="${outgoing.peopleName!}">
                    </td>
                    <td class="gt-td-title">处  室</td>
                    <td class="pd0" colspan="2" >
                        <input class="layui-input" type="text" id="peopleUnit" name="peopleUnit" value="${outgoing.peopleUnit!}">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">外出地点</td>
                    <td class="pd0" colspan="5" >
                        <input class="layui-input" type="text" id="outAdress" name="outAdress" value="${outgoing.outAdress!}">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">外出日期</td>
                    <td class="pd0" colspan="2" >
                        <input type="text" class="layui-input layui-date" id="outDate" name="outDate" value="${(outgoing.outDate!.now)?string('yyyy-MM-dd')}">
                    </td>
                    <td class="gt-td-title">申请日期</td>
                    <td class="pd0" colspan="2" >
                        <input type="text" class="layui-input layui-date" id="applyDate" name="applyDate" value="${(outgoing.applyDate!.now)?string('yyyy-MM-dd')}" readonly >
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">计划离岗时间</td>
                    <td class="pd0" colspan="2" >
                        <select id="departureTime" name="departureTime" lay-verify="required">
                            <option value="8:30" <#if outgoing.departureTime?? && outgoing.departureTime=='8:30'>selected </#if>>8:30</option>
                            <option value="9:30" <#if outgoing.departureTime?? && outgoing.departureTime=='9:30'>selected </#if>>9:30</option>
                            <option value="10:30" <#if outgoing.departureTime?? && outgoing.departureTime=='10:30'>selected </#if>>10:30</option>
                        </select>
                    </td>
                    <td class="gt-td-title">预计到岗时间</td>
                    <td class="pd0" colspan="2" >
                        <select id="arrivalTime" name="arrivalTime" lay-verify="required">
                            <option value="15:30" <#if outgoing.arrivalTime?? && outgoing.arrivalTime=='15:30'>selected </#if>>15:30</option>
                            <option value="16:30" <#if outgoing.arrivalTime?? && outgoing.arrivalTime=='16:30'>selected </#if>>16:30</option>
                            <option value="17:30" <#if outgoing.arrivalTime?? && outgoing.arrivalTime=='17:30'>selected </#if>>17:30</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">外出事由</td>
                    <td colspan="5">
                        <textarea class="layui-textarea" id="reason" name="reason" lay-verify="content">${outgoing.reason!}</textarea>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">承办意见</td>
                    <td colspan="5" class="gtmapSign" signKey="cbyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                <tr>
                    <td class="gt-td-title">办公室意见</td>
                    <td colspan="5" class="gtmapSign" signKey="bgsyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                <tr>
                    <td class="gt-td-title">办公室主任</br>审批</td>
                    <td colspan="5" class="gtmapSign" signKey="bgszr" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                <tr>
                    <td class="gt-td-title">分管领导</br>审批</td>
                    <td colspan="5" class="gtmapSign" signKey="fgld" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
            </table>
        </div>
    </form>
</div>
<script type="text/javascript">
    layui.use(['form','laydate'], function() {
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;
        laydate.render({
            elem: '#beginTime' //指定元素
        });
        laydate.render({
            elem: '#endTime'//指定元素
        });
        laydate.render({
            elem: '#outDate'//指定元素
            //range: true
        });
        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });
        $(function(){
            var view = $("#view").val();
            if(view!=""){
                $(".gt-container").css('top',"0px");
            }else {
            }
        });
        //表单提交
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/outgoing/save",
                dataType: "json",
                data: $("#outgoingForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#id").val(data.empty.id);
                        });
                    } else {
                        layer.msg(data.message,{icon:2,time:2000});
                    }
                }
            });
        }
    });
</script>
</body>


