<@com.html title="出差列表" import="viewList,screen" />
<style>
    a:hover{
        color: #08c;
    }
</style>
<body class="gtmap">
<div class="gt-body">
    <#if type=="view">
    <#else>
        <@toolbar show="del"/>
    </#if>
    <div class="gtmap-body">
        <div class="gtmap-cnt">
            <div class="menu-group">
                <input type="hidden" id="outType" name="outType" value="${outType!}"/>
                <form class="layui-form gt-form-group gt-form-bdgroup">
                    <div class="gt-new-form-item">
                        <div class="right-btnbox">
                            <div class="layui-btn layui-btn-sm">
                                <div onclick="loadInfo()"><i class="iconfont icon-search" ></i>搜 索</div>
                            </div>
                        </div>
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        申请人
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" name="peopleName" id="peopleName" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        归属部门
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" name="peopleUnit" id="peopleUnit" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        出差理由
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" name="reason" id="reason" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="tablebox">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        出差列表
                    </div>
                </div>
                <div id="table1">
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.onresize=initHeight;

        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/outgoing/findByPage',
                dataType: "json",
                where: {
                    "peopleName": $("#peopleName").val(),
                    "peopleUnit": $("#peopleUnit").val(),
                    "reason": $("#reason").val(),
                    "outType": $("#outType").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'id', title: 'id', width: '3%', fixed: 'left', hide: true}
                    , {field: 'peopleName', title: '申请人', width: '10%',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.id + "')";
                                return "<a onclick=\"" + funStr + "\">"+d.peopleName+"</a>"
                            }}
                    , {field: 'peopleUnit', title: '科室', width: '20%'}
                    , {field: 'beginTime', title: '开始时间', width:'10%',templet:"<div>{{layui.util.toDateString(d.beginTime,'yyyy-MM-dd')}}</div>"}
                    , {field: 'endTime', title: '结束时间', width: '10%',templet:"<div>{{layui.util.toDateString(d.endTime,'yyyy-MM-dd')}}</div>"}
                    , {field: 'destination', title: '目的地', width: '23%'}
                    , {field: 'reason', title: '出差理由'}
                ]],
                page: true,
                done: function(res, curr, count){
                    $('.layui-table-view td[data-field="peopleName"]').on({
                        mouseenter: function () {
                            var xmmc = $(this).next().next().next().next().next().text();
                            tips = layer.tips(
                                    "<span style='height: 400px;width:400px;color:#000;font-weight: bolder'>"+
                                    "<span style='text-align: left'>出差理由："+$.trim(xmmc)+"</span>"+
                                    "</span>", this, {
                                        tips: [3, '#fff'],
                                        time: 0,
                                        // area: 'auto',
                                        maxWidth: 500
                                    });
                        },
                        mouseleave: function () {
                            layer.close(tips);
                        }
                    });
                    //渲染收藏实例
                    $.each($("[data-content=collection] i"),function () {
                        $(this).parent('div').addClass("active");
                    });
//                    $('#todo-task span', window.parent.document).html('('+count+')');
                }
            });
        };
        //跳往编辑页面
        window.goViewProject=function(id){
            window.open("${base}/outgoing/index?outType=2&view=true&processInsId="+id);
        };

        window.deleteAsset = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].id);
                }
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/outgoing/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除地块）
        $("#del").click(function (e) {
            deleteAsset();
        });

        //初始化查询
        loadInfo();

        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        })
        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-32;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
