<@com.html title="公开文件列表" import="viewList,screen,main" />
<style>
    a:hover{
        color: #08c;
    }
</style>
<body class="gtmap">
<div class="gt-body">

    <div class="layui-row gt-toolbar">
        <div class="layui-col-xs12">
            <button class="layui-btn layui-btn-sm" type="button" id="upload">
                <i class="iconfont icon-cloud-upload"></i> 上 传
            </button>
    <#if type=="">
            <button class="layui-btn layui-btn-danger layui-btn-sm" type="button" id="del">
                <i class="layui-icon layui-icon-delete"></i> 删 除
            </button>
    <#else>
    </#if>
        </div>
    </div>

    <div class="gtmap-body">
        <div class="gtmap-cnt">
            <div class="menu-group">
                <input type="hidden" id="outType" name="outType" value="${outType!}"/>
                <input type="hidden" id="downUrl" name="downUrl" value="${downUrl!}"/>
                <form class="layui-form gt-form-group gt-form-bdgroup">
                    <div class="gt-new-form-item">
                        <div class="right-btnbox">
                            <div class="layui-btn layui-btn-sm">
                                <div onclick="loadInfo()"><i class="iconfont icon-search"></i>搜 索</div>
                            </div>
                        </div>
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        文件名
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" id="fileName" name="fileName" lay-verify="required" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        发布人
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <input type="text" id="newPublisher" name="newPublisher" lay-verify="required" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="tablebox">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        公开文件列表
                    </div>
                </div>
                <div id="table1">
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code','upload'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var upload = layui.upload;
        var tableHeight=initHeight("init");
        window.onresize=initHeight;

        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/news/findByPage',
                dataType: "json",
                where: {
                    "newType": 4,
                    "fileName": $("#fileName").val(),
                    "newPublisher": $("#newPublisher").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'id', title: 'id', width: '3%', fixed: 'left', hide: true}
                    , {field: 'fileId', title: 'fileId', width: '3%', hide: true}
                    , {field: 'fileName', title: '文件名称',templet:
                            function (d) {
                                var funStr ="goDetail('" + d.fileId + "')";
                                return "<a onclick=\"" + funStr + "\">"+d.fileName+"</a>"
                            }}
                    , {field: 'newPublisher', title: '发布人', width: '20%'}
                    , {field: 'newUpdateDate', title: '发布时间', width: '20%',templet:"<div>{{layui.util.toDateString(d.newUpdateDate,'yyyy-MM-dd')}}</div>"}
                ]],
                page: true,
                /** --------------- table加载完后的回调----------*/
                done: function(res, curr, count){
                    $('.layui-table-view td[data-field="fileName"]').on({
                        mouseenter: function () {
                            var xmmc = $(this).text();
                            tips = layer.tips(
                                    "<span style='height: 400px;width:400px;color:#000;font-weight: bolder'>"+
                                    "<span style='text-align: left'>文件名："+$.trim(xmmc)+"</span>"+
                                    "</span>", this, {
                                        tips: [3, '#fff'],
                                        time: 0,
                                        // area: 'auto',
                                        maxWidth: 500
                                    });
                        },
                        mouseleave: function () {
                            layer.close(tips);
                        }
                    });
                    //渲染收藏实例
                    $.each($("[data-content=collection] i"),function () {
                        $(this).parent('div').addClass("active");
                    });
//                    $('#todo-task span', window.parent.document).html('('+count+')');
                }
            });
        };


        window.deleteMessage = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var fileIds = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].id);
                    fileIds.push(data[i].fileId);
                }
                if (ids.length == 0) {
                    // layer.msg("请选择需要删除的数据！",{icon:2,time:2000});
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/news/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
                $.ajax({
                    type : "post",
                    url : "${base}/news/deleteFile",
                    traditional: true,
                    data : {"ids" : fileIds},
                    success : function (data) {
                    }
                });
            });
        };

        //点击事件（删除）
        $("#del").click(function (e) {
            deleteMessage();
        });

        upload.render({
            elem: '#upload'
            ,url: '${base}/news/uploadFile?newType=4'
            ,accept: 'file'
            ,done: function(res){
                layer.msg(res.msg);
                loadInfo();
            }
        });

        //跳转下载
        window.goDetail=function(fileId){
            var downUrl = $("[name='downUrl']").val();
            window.open(downUrl+fileId);
        };

        //初始化查询
        loadInfo();

        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-32;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
