<@com.html title="通知公告" import="layui,jquery,ueditor,common,font,main"/>
<body class="gtmap">
<div class="gt-container">
    <form action="" class="layui-form" id="newsForm">
    <#if view=="">
        <@toolbar show="save,print" />
    <#else>
    </#if>

    <#-- 存储隐藏值-->
        <input type="hidden" class="input-text" id="id" name="id" value="${news.id!}">
        <input type="hidden" class="input-text" id="newType" name="newType" value="${news.newType!}">
        <input type="hidden" id="view" name="view" value="${view!}"/>

        <div class="gt-content">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    通知公告
                </div>
            </div>
            <table class="layui-table gt-special-table table-border">
                <tbody>
                <tr>
                    <td class="gt-td-title">标  题</td>
                    <td colspan="8" >
                        <input class="layui-input" type="text" id="newTitle" name="newTitle" value="${news.newTitle!}" lay-verify="required">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">作  者</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="newAuthor" name="newAuthor" value="${news.newAuthor!}">
                    </td>
                    <td class="gt-td-title">公告等级</td>
                    <td class="pd0" colspan="2">
                        <select id="grade" name="grade">
                            <option value="一般" <#if news.grade?? && news.grade=='一般'>selected </#if>>一般</option>
                            <option value="紧急" <#if news.grade?? && news.grade=='紧急'>selected </#if>>紧急</option>
                            <option value="非常紧急" <#if news.grade?? && news.grade=='非常紧急'>selected </#if>>非常紧急</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">发布人</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="newPublisher" name="newPublisher" value="${news.newPublisher!}">
                    </td>
                    <td class="gt-td-title">发布时间</td>
                    <td class="pd0" colspan="2">
                        <input class="layui-input layui-date" type="text" id="newUpdateDate" name="newUpdateDate" value="${(news.newUpdateDate!.now)?string('yyyy-MM-dd')}">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">摘  要</td>
                    <td colspan="8">
                        <textarea class="layui-textarea" id="newSummary" name="newSummary" lay-verify="content">${news.newSummary!}</textarea>
                    </td>
                </tr>
                <tr>
                    <td colspan="9">
                        <script id="newContent" name="newContent" class="newContent" type="text/plain">${news.newContent!}</script>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </form>
</div>
</body>
<script type="text/javascript">
    //实例化编辑器
    var ue = UE.getEditor('newContent');
    ue.ready(function () {
        //自定义请求参数
        ue.execCommand('serverparam', {
            'id': '${news.id!}',
        });
        ue.queryCommandValue('serverparam');

        UE.Editor.prototype._bkGetActionUrl = UE.Editor.prototype.getActionUrl;
        UE.Editor.prototype.getActionUrl = function (action) {
            if (action = ue.getOpt("imageActionName")){
                return getRoot()+ ue.getOpt("imageActionName");
            }else if(action = ue.getOpt("fileActionName")){
                return getRoot()+ ue.getOpt("fileActionName");
            }
            else {
                return this._bkGetActionUrl.call(this.action);
            }
        }
    });
    layui.use(['form','laydate'], function() {
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;

        laydate.render({
            elem: '#newUpdateDate', //指定元素
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });

        //表单提交
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/news/save",
                dataType: "json",
                data: $("#newsForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.3,
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.alert(data.message, {icon: 6});
                        $("#id").val(data.empty.id);
                        opener.loadInfo();

                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }
                }
            });
        }
        //监听提交
        $(document).on('click','#acceptMan',function(){
            var linkId = $("#id").val();
            var peopleId = "acceptMan";//此处配置业务表单人员的字段
            //x_admin_show('<i class="icon-user" style="fon-:"></i>'+" 人员选择","${base}/promulgator/index?linkId="+linkId+"&peopleId="+peopleId,"400","350");
        });

    });
</script>
</html>
