<@com.html title="消息传递管理列表" import="viewList,screen" />
<style>
    a:hover{
        color: #08c;
    }
</style>
<body class="gtmap">
<div class="gt-body">
    <@toolbar show="add,edit,del"/>
    <div class="gtmap-body">
        <div class="gtmap-cnt">
            <div class="menu-group">
                <input type="hidden" id="outType" name="outType" value="${outType!}"/>
                <form class="layui-form gt-form-group gt-form-bdgroup">
                    <div class="gt-new-form-item">
                        <div class="right-btnbox">
                            <div class="layui-btn layui-btn-sm">
                                <div onclick="loadInfo()"><i class="iconfont icon-search" ></i>搜 索</div>
                            </div>
                        </div>
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        标题
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" name="messagesendTitle" id="messagesendTitle" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        查看状态
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <select name="isRead" id="isRead" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                        <option value=""></option>
                                        <option value="0">未查看</option>
                                        <option value="1">已查看</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        接收人
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" name="acceptMans" id="acceptMans" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="tablebox">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        消息传递列表
                    </div>
                </div>
                <div id="table1">
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });
        var tableHeight=initHeight("init");
        window.onresize=initHeight;

        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/message/findByPage',
                dataType: "json",
                where: {
                    "messagesendTitle": $("#messagesendTitle").val(),
                    "isRead": $("#isRead").val(),
                    "acceptMans": $("#acceptMans").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'id', title: 'id', width: '3%', fixed: 'left', hide: true}
                    , {
                        field: 'messagesendTitle', title: '标题', templet: function (d) {
                            var funStr = "toEditMessage('" + d.id + "')";
                            return "<a onclick=\"" + funStr + "\">" + d.messagesendTitle + "</a>"
                        }
                    }
                    , {field: 'acceptMans', title: '接收人', width: '23%'}
                    , {field: 'isRead', title: '是否查看', width: '10%',templet:
                            function(d){
                                if(d.isRead=="0"){
                                    return "未查看";
                                }else {
                                    return "已查看";
                                }
                            }
                    }
                    , {field: 'messagesendManName', title: '发送人', width: '10%'}
                    , {field: 'messagesendDate', title: '发送时间', width: '14%'}
                ]],
                page: true,                done: function(res, curr, count){
                    $('.layui-table-view td[data-field="messagesendTitle"]').on({
                        mouseenter: function () {
                            var xmmc = $(this).text();
                            tips = layer.tips(
                                    "<span style='height: 400px;width:400px;color:#000;font-weight: bolder'>"+
                                    "<span style='text-align: left'>标题："+$.trim(xmmc)+"</span>"+
                                    "</span>", this, {
                                        tips: [3, '#fff'],
                                        time: 0,
                                        // area: 'auto',
                                        maxWidth: 500
                                    });
                        },
                        mouseleave: function () {
                            layer.close(tips);
                        }
                    });
                    //渲染收藏实例
                    $.each($("[data-content=collection] i"),function () {
                        $(this).parent('div').addClass("active");
                    });
//                    $('#todo-task span', window.parent.document).html('('+count+')');
                }
            });
        };

        //初始化查询
        loadInfo();

        //跳往编辑页面
        $("#edit").click(function (e) {
            var ids = [];
            var checkStatus = table.checkStatus('idTest')
                    ,data = checkStatus.data;
            for(var i=0;i<data.length;i++){
                ids.push(data[i].lawId);
            }
            if (ids.length == 0) {
                layer.msg('请勾选要修改的数据', function(){
                    //关闭后的操作
                });
                return;
            }
            if (ids.length > 1) {
                layer.msg('请选择一条记录', function(){
                    //关闭后的操作
                });
                return;
            }
            layer.open({
                type: 2 //此处以url/ 举例
                ,title: '编辑消息'
                ,skin: 'layer-ext-blue'
                ,area: ['800px', '398px']
                ,shade: 0.4
                ,maxmin: true
                ,moveType: 0 //拖拽模式，0或者1
                ,content:'${base}/message/index?proid='+checkStatus.data[0].id
                ,btnAlign: 'c'
            });
            //window.open("${base}/message/index?proid="+checkStatus.data[0].id);
        });

        //跳往新增页面
        window.toEditMessage = function (id) {
//            if (id==null){
//                id = UUID(16,16);
//            }
            layer.open({
                type: 2 //此处以url/ 举例
                ,title: '编辑消息'
                ,skin: 'layer-ext-blue'
                ,area: ['800px', '440px']
                ,shade: 0.4
                ,maxmin: true
                ,moveType: 0 //拖拽模式，0或者1
                ,content:'${base}/message/index?proid='+id
                ,btnAlign: 'c'
            });
            //window.open("${base}/message/index?proid="+id);
        };

        window.deleteMessage = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].id);
                }
                if (ids.length == 0) {
                    // layer.msg("请选择需要删除的数据！",{icon:2,time:2000});
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/message/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除消息）
        $("#del").click(function (e) {
            deleteMessage();
        });
        //点击事件（新增消息）
        $("#add").click(function (e) {
            toEditMessage();
        });

        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-32;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
