<@com.html title="消息传递" import="layui,common,font,main,xadmin"/>
<style>
    .gtmap{
        background-color: white;
    }
</style>

<body class="gtmap">
    <form class="layui-form" id="messageForm">
        <input type="hidden" name="id" value="${message.id!}" id="id" >
        <input type="hidden" name="accept" value="${accept!}" id="accept" >
        <input type="hidden" id="messagesendDate" name="messagesendDate" value="${(message.messagesendDate!.now)?string('yyyy-MM-dd HH:mm:ss')}" class="layui-input layui-date">
        <input type="hidden" id="createTime" name="createTime" value="${(message.createTime?string('yyyy-MM-dd HH:mm:ss'))!}">
        <div class="layui-card">
            <div class="layui-card-body" style="padding: 29px">
                <div class="layui-row  gt-form-group">
                    <div class="layui-row layui-col-space16 layui-form-item">
                        <div class="layui-col-sm12">
                            <label class="layui-form-label">
                                <div class="gt-label-text">
                                    <span class="red-text">*</span>标  题
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <input type="text" id="messagesendTitle" name="messagesendTitle" lay-verify="required" value="${message.messagesendTitle!}" class="layui-input">
                            </div>
                        </div>
                    </div>
                    <div class="layui-row layui-col-space16 layui-form-item">
                        <div class="layui-col-sm12">
                            <label class="layui-form-label">
                                <div class="gt-label-text">
                                    <span class="red-text">*</span>发送人
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <input type="text" id="messagesendManName" name="messagesendManName" lay-verify="required" value="${message.messagesendManName!}" class="layui-input">
                            </div>
                        </div>
                    </div>
                    <div class="layui-row layui-col-space16 layui-form-item">
                        <div class="layui-col-sm12">
                            <label class="layui-form-label">
                                <div class="gt-label-text">
                                    <span class="red-text">*</span>接收人
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <#if accept != "">
                                    <input type="text" value="${message.acceptMans!}" readonly="readonly" class="layui-input" autocomplete="off">
                                <#else>
                                <input type="text" id="acceptMans" name="acceptMans" value="${message.acceptMans!}" class="layui-input" lay-filter="selectUser" autocomplete="off">
                                </#if>
                            </div>
                        </div>
                    </div>
                    <div class="layui-row layui-col-space16 layui-form-item">
                        <div class="layui-col-sm12">
                            <label class="layui-form-label">
                                <div class="gt-label-text">
                                    <span class="red-text">*</span>消息内容
                                </div>
                            </label>
                            <div class="layui-input-block">
                                <textarea id="messagesendContent" name="messagesendContent" class="layui-textarea">${message.messagesendContent!}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <#if accept != "">
        <#else>
            <div class="layer-footer-btn">
                <div class="layui-btn layui-btn-sm" id="save" lay-submit lay-filter="formSave" style="padding: 0px 10px">保 存</div>
                <div class="layui-btn layui-btn-sm layui-btn-primary" id="close" data-dismiss="modal" style="padding: 0px 10px">关 闭</div>
            </div>
        </#if>
        </div>
    </form>
<script type="text/javascript">
    layui.use(['form','laydate'], function(){
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;
        //各种基于事件的操作，下面会有进一步介绍
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });
//        laydate.render({
//            elem: '#messagesendDate', //指定元素
//            type:'datetime'
//            //range: true
//        });

        $(document).on('click',"#close",function(){
            window.parent.location.reload();
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });

        /**
         * 表单提交
         */
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/message/save",
                dataType: "json",
                data: $("#messageForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    //window.parent.location.reload();
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#id").val(data.empty.id);
                            //刷新列表
//                            opener.loadInfo();
                            parent.location.reload();
                        });
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }

                }
            });

        }

        //监听提交
        $(document).on('click','#acceptMans',function(){
            var linkId = $("#id").val();
            var peopleId = "acceptMans";//此处配置对应业务表单人员的字段
            layer.open({
                type: 2 //此处以url/ 举例
                ,title: '人员选择'
                ,skin: 'layer-ext-blue'
                ,area: ['430px', '380px']
                ,shade: 0.4
                ,maxmin: true
                ,moveType: 0 //拖拽模式，0或者1
                ,content:'${base}/promulgator/index?linkId='+linkId+'&peopleId='+peopleId
                ,btnAlign: 'c'
            });
            //x_admin_show('<i class="icon-user" style="fon-:"></i>'+" 人员选择","${base}/promulgator/index?linkId="+linkId+"&peopleId="+peopleId,"400","360");
            //layer.open("");
        });
    });

</script>
</body>