<@com.html title="会议室列表" import="viewList,screen" />
<body class="gtmap">
<div class="gt-body">
    <@toolbar show="add,edit,del"/>
    <div class="gtmap-body">
        <div class="gtmap-cnt">
            <div class="menu-group">
                <input type="hidden" id="outType" name="outType" value="${outType!}"/>
                <form class="layui-form gt-form-group gt-form-bdgroup">
                    <div class="gt-new-form-item">
                        <div class="right-btnbox">
                            <div class="layui-btn layui-btn-sm">
                                <div onclick="loadInfo()"><i class="iconfont icon-search"></i>搜 索</div>
                            </div>
                        </div>
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        会议室
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" id="roomName" name="roomName" class="layui-input layui-input-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="tablebox">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        会议室列表
                    </div>
                </div>
                <div id="table1">
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        layer.config({
            extend: 'blue/layer.css' //同样需要加载新皮肤
        });
        var tableHeight=initHeight("init");
        window.onresize=initHeight;

        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/meetroom/findByPage',
                dataType: "json",
                where: {
                    "roomName": $("#roomName").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'roomId', title: 'roomId', width:'10%', fixed: 'left', hide: true}
                    , {field: 'roomName', title: '名称', width:'10%'}
                    , {field: 'roomAdress', title: '地点', width:'20%'}
                    , {field: 'peopleNum', title: '可容纳人数', width:'8%'}
                    , {field: 'roomEquipment', title: '设备信息', width:'20%'}
                    , {field: 'roomDescribe', title: '描述'}
                ]],
                page: true
            });
        };

        //初始化查询
        loadInfo();

        //点击事件（删除会议室）
        $("#del").click(function (e) {
            deleteMeetroom();
        });

        //新增事件（新增会议室信息）
        $("#add").click(function (e) {
            var roomId  = "";
            layer.open({
                type: 2 //此处以url/ 举例
                ,title: '会议室登记'
                ,skin: 'layer-ext-blue'
                ,area: ['800px', '398px']
                ,shade: 0.4
                ,maxmin: true
                ,moveType: 0 //拖拽模式，0或者1
                ,content:'${base}/meetroom/index?roomId='+roomId
                ,btnAlign: 'c'
            });
        });

        //跳往编辑页面
        $("#edit").click(function (e) {
            var ids = [];
            var checkStatus = table.checkStatus('idTest')
                    ,data = checkStatus.data;
            for(var i=0;i<data.length;i++){
                ids.push(data[i].lawId);
            }
            if (ids.length == 0) {
                layer.msg('请勾选要修改的数据', function(){
                    //关闭后的操作
                });
                return;
            }
            if (ids.length > 1) {
                layer.msg('请选择一条记录', function(){
                    //关闭后的操作
                });
                return;
            }
            layer.open({
                type: 2 //此处以url/ 举例
                ,title: '会议室登记'
                ,skin: 'layer-ext-blue'
                ,area: ['800px', '398px']
                ,shade: 0.4
                ,maxmin: true
                ,moveType: 0 //拖拽模式，0或者1
                ,content:'${base}/meetroom/index?roomId='+checkStatus.data[0].roomId
                ,btnAlign: 'c'
            });
        });

        window.deleteMeetroom = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].roomId);
                }
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/meetroom/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-32;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
