<@com.html title="政策法规列表" import="viewList,list,screen" />
<style>
    a:hover{
        color: #08c;
    }
</style>
<body class="gtmap">
<div class="layui-row gt-toolbar">
    <div class="layui-col-xs12">
        <button class="layui-btn layui-btn-sm" type="button" id="edit">
            <i class="layui-icon layui-icon-edit"></i> 修 改
        </button>
        <button class="layui-btn layui-btn-danger layui-btn-sm" type="button" id="del">
            <i class="layui-icon layui-icon-delete"></i> 删 除
        </button>
    </div>
</div>
<div class="gtmap-body">
    <div class="gtmap-cnt">
        <div class="menu-group">
            <form class="layui-form gt-form-group gt-form-bdgroup">
                <input type="hidden" class="input-text" id="treeLinkId" name="treeLinkId" value="${treeLinkId!}">
                <input type="hidden" class="input-text" id="treeName" name="treeName" value="${treeName!}">
                <input type="hidden" class="input-text" id="effectLeve" name="effectLeve" value="${effectLeve!}">
                <input type="hidden" class="input-text" id="userArea" name="userArea" value="${userArea!}">
                <input type="hidden" class="input-text" id="fpubDpt" name="fpubDpt" value="${fpubDpt!}">
                <div class="gt-new-form-item">
                    <div class="right-btnbox">
                        <div class="layui-btn layui-btn-sm">
                            <div onclick="loadInfo()"><i class="iconfont icon-search"></i>搜索</div>
                        </div>
                    </div>
                    <div class="left-form">
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    标题
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="ftitle" id="ftitle" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                        <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                            <label class="layui-form-label layui-form-label-sm">
                                <div class="gt-label-text">
                                    发布单位
                                </div>
                            </label>
                            <div class="layui-input-block ">
                                <input type="text" name="fpubDpt1" id="fpubDpt1" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            <#--<div class="menu-more" data-flag="down">-->
                <#--显示更多筛选条件-->
            <#--</div>-->
        </div>
        <div class="tablebox">
        <#if type=="view">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    政策法规列表
                </div>
            </div>
        </#if>
            <div id="table1">
            </div>
        </div>
    </div>
</div>

</body>
<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");

        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/laws/findByPage',
                dataType: "json",
                where: {
                    "ftitle":$("#ftitle").val(),
                    "fpubDpt":$("#fpubDpt1").val(),
//                    "treeLinkId":$("#treeLinkId").val(),
                    "treeName":$("#treeName").val(),
                    "effectLeve":$("#effectLeve").val(),
                    "userArea":$("#userArea").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'lawId', title: 'lawId', width: '3%', fixed: 'left', hide: true}
                    , {field: 'ftitle', title: '标题',templet:
                            function (d) {
                                var funStr ="showLaws('" + d.lawId + "')";
                                return "<a onclick=\"" + funStr + "\">"+d.ftitle+"</a>"
                            }}
                    , {field: 'fkeyword', title: '主题词', width: '27%'}
                    , {field: 'fpubDpt', title: '发布单位', width: '13%'}
                    , {field: 'fpubDate', title: '颁布日期', width: '12%',templet:"<div>{{layui.util.toDateString(d.fpubDate,'yyyy-MM-dd')}}</div>"}
                ]],
                page: true,
                done: function(res, curr, count){
                    $('.layui-table-view td[data-field="ftitle"]').on({
                        mouseenter: function () {
                            var xmmc = $(this).text();
                            tips = layer.tips(
                                    "<span style='height: 400px;width:400px;color:#000;font-weight: bolder'>"+
                                    "<span style='text-align: left'>标题："+$.trim(xmmc)+"</span>"+
                                    "</span>", this, {
                                        tips: [3, '#fff'],
                                        time: 0,
                                        // area: 'auto',
                                        maxWidth: 500
                                    });
                        },
                        mouseleave: function () {
                            layer.close(tips);
                        }
                    });
                    //渲染收藏实例
                    $.each($("[data-content=collection] i"),function () {
                        $(this).parent('div').addClass("active");
                    });
//                    $('#todo-task span', window.parent.document).html('('+count+')');
                }
            });
        };

        //初始化查询
        loadInfo();

        <#--//跳往新增页面-->
        <#--window.toLaws = function (lawId) {-->
            <#--var treeLinkId = $("#treeLinkId").val();-->
            <#--var treeName = $("#treeName").val();-->
            <#--window.open("${base}/laws/edit?lawId="+lawId+"&treeLinkId="+treeLinkId+"&treeName="+treeName);-->
        <#--};-->

        //跳往查看页面
        window.showLaws = function (lawId) {
            window.open("${base}/laws/showLaws?lawId="+lawId);
        };

        //删除事件
        $("#del").click(function (e) {
            deleteLaws();
        });

//        //新增政策法规
//        $("#add").click(function (e) {
//            toLaws();
//        });

        //跳往编辑页面
        $("#edit").click(function (e) {
            var ids = table.checkStatus('idTest');
            if (ids.length == 0) {
                layer.msg('请勾选要修改的数据', function(){
                    //关闭后的操作
                });
                return;
            }
            if (ids.length > 1) {
                layer.msg('请选择一条记录', function(){
                    //关闭后的操作
                });
                return;
            }
            var treeLinkId = $("#treeLinkId").val();
            var treeName = $("#treeName").val();
            window.open("${base}/laws/edit?lawId="+ids.data[0].lawId+"&treeLinkId="+treeLinkId+"&treeName="+treeName);
        });

        window.deleteLaws = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                var checkStatus = table.checkStatus('idTest')
                        ,data = checkStatus.data;
                for(var i=0;i<data.length;i++){
                    ids.push(data[i].lawId);
                }
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/laws/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.alert(data.message, {icon: 6});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };
        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        });
        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-11;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
