<@com.html title="政策法规" import="viewList,jquery,ztree,font"/>
<style>
    html, body {
        margin: 0;
        padding: 0px;
        height: 100%;
        background-color: rgb(233, 238, 243);
        box-sizing: border-box;
    }
    .gt-body{
        height:100%;
    }
    .main-box {
        background-color: #fff;
        height: 100%;
        box-sizing: border-box;
        /*padding: 10px;*/
    }

    .left-box {
        background-color: #fff;
        width: 300px;
        float: left;
        height: 100%;
        border-right: 1px solid #ccc;
        box-sizing: border-box;
        padding: 16px;
        position: relative;
    }

    .right-box {
        margin-left: 300px;
        height: 100%;
        background-color: #fff;
        position: relative;
    }
    .ztree * {
        font-size: 14px!important;
    }
    .content_wrap {
        position: absolute;
        top: 45px;
        right: 10px;
        left: 8px;
        bottom: 16px;
    }

    .zTreeSearch input {
        width: 120px;
        height: 24px;
        line-height: 24px;
        vertical-align: middle;
    }

    .zTreeSearch span.iconfont {
        vertical-align: middle;
        font-size: 20px;
        cursor: pointer;
        visibility: hidden;
    }

    .iconfont {
        -webkit-text-stroke-width: 0;
    }
</style>
<body class="gtmap">
    <div class="gt-body">
        <input type="hidden" name="type" id="type" value="${type!}"/>
        <div class="main-box">
            <div class="left-box">
                <div class="zTreeSearch" id="zTree_zTreeSearch">
                    <input type="text" class="layui-input" name="department" placeholder="请输入" autocomplete="off" style="display:inline-block;">
                    <button type="button" class="layui-btn layui-btn-xs"><i class="icon iconfont icon-search">搜索</i></button>
                    <span class="zTree-search-tip"></span>
                    <span class="icon iconfont icon-left" title="上一个" style="font-size: 14px!important;"></span>
                    <span class="icon iconfont icon-right" title="下一个" style="font-size: 14px!important;"></span>
                </div>
                <div class="content_wrap">
                    <ul id="lawsType" class="ztree defaultColor" style="width:96%;height: 98%; overflow-y:auto;"></ul>
                </div>
            </div>
            <div class="right-box">
                <div id="hhh">

                </div>
            </div>
        </div>
    </div>
</body>
<script>
    layui.use(['jquery', 'form'], function () {
        var form = layui.form;
        initZTree();
        var type = $("[name='type']").val();
        if(type == "view"){
            var allUrl = '${base}/laws/list?treeLinkId='+'&treeName='+'&type=view';
        } else if(type == "manage"){
            var allUrl = '${base}/laws/list?treeLinkId='+'&treeName='+'&type=manage';
        }
        var allContent = "<iframe src='"+allUrl+"'frameborder=\"0\" style=\"width: 100%;height:100%; position: absolute; \" ></iframe>";
        $("#hhh").html(allContent);
    });

    //树设置
    var setting = {
        view: {
            dblClickExpand: false
        },
        data: {
            simpleData: {
                enable: true,
                idKey: "typeId",   //节点数据中保存唯一标识的属性名称
                pIdKey: "ftypeParentId",    //节点数据中保存其父节点唯一标识的属性名称
                rootPId: -1  //用于修正根节点父节点数据，即 pIdKey 指定的属性值
            },
            key: {
                name: "fname"  //zTree 节点数据保存节点名称的属性名称  默认值："name"
            }
        },
        callback: {
            onClick: zTreeOnClick
        }
    };

    //初始化树
    var treeObj, rMenu,ztreeNode,zTree_zTree;
    var rMenu;
    function initZTree() {
        $.ajax({
            type:"GET",
            url:"/oa/lawsType/getLawsTypeList",
            dataType:"json",
            async:true,
            success:function(lawsTypeList){
                $.fn.zTree.init($("#lawsType"), setting, lawsTypeList); //初始化树
                rMenu=$("#rMenu");
                treeObj = $.fn.zTree.getZTreeObj("lawsType");
                var nodes = treeObj.getNodes();
                treeObj.hideNode(treeObj.getNodeByParam("isUse","否"));
                treeObj.expandAll(true);   //true 节点全部展开、false节点收缩
                zTree_zTree = $.fn.zTree.getZTreeObj("lawsType");
            }
        });
    }
    /**
     * 单击赋值属性值
     * @param event
     * @param treeId
     * @param treeNode
     */
    function zTreeOnClick(event, treeId, treeNode) {
        treeObj = $.fn.zTree.getZTreeObj("lawsType");
        if(treeNode.isParent){
            if(treeNode.open) {
                treeObj.expandNode(treeNode, false, null, null);
            }else{
                treeObj.expandNode(treeNode, true, null, null);
            }
            return false;
        }

        var treeLinkId = getCurrentRoot(treeNode);

        var type = $("[name='type']").val();
        var allUrl = '${base}/laws/list?treeLinkId='+treeLinkId+'&treeName='+treeNode.fname+"&type="+type;
        var allContent = "<iframe src='"+allUrl+"'frameborder=\"0\" style=\"width: 100%;height:100%; position: absolute; \" ></iframe>";
        $("#hhh").html(allContent);
    }

    //获取当前节点的根节点(treeNode为当前节点)
    function getCurrentRoot(treeNode){
        if(treeNode.getParentNode()!=null){
            var parentNode = treeNode.getParentNode();
            return getCurrentRoot(parentNode);
        }else{
            return treeNode.typeId;
        }
    }
    //避免搜索触发的点击事件打断中文输入
    var cpLock = true;
    $("#zTree_zTreeSearch input").on('compositionstart', function () {
        cpLock = false;
    });
    $("#zTree_zTreeSearch input").on('compositionend', function () {
        cpLock = true;
    });

    $("#zTree_zTreeSearch input").on("input", function (e) {
        e.preventDefault();
        var _this = this;
        setTimeout(function(){
            if (cpLock && _this.value != null && _this.value != "") {
                //开始写逻辑
                zTree_searchText();
                _this.focus();
            }
        },0)
    });
    $("#zTree_zTreeSearch button").click(function () {
        zTree_searchText();
    });

    var zTree_nodeList = [];
    function zTree_searchText () {
        var text = $("#zTree_zTreeSearch input").val();
        if ($.trim(text) == "") {
            $("#zTree_zTreeSearch .zTree-search-tip").html("");
            $("#zTree_zTreeSearch span.iconfont").css("visibility", "hidden");
            return;
        }

        zTree_nodeList = zTree_zTree.getNodesByParamFuzzy("fname", text);
        if (zTree_nodeList.length == 0) {
            $("#zTree_zTreeSearch .zTree-search-tip").html("搜不到");
            $("#zTree_zTreeSearch span.iconfont").css("visibility", "hidden");
            return;
        }

        $("#zTree_zTreeSearch span.iconfont").css("visibility", "visible");
        zTree_selectNode(0);
    }

    // 选中指定下标节点
    function zTree_selectNode (index) {
        if (index == -1) {
            index = zTree_nodeList.length - 1;
        } else if (index == zTree_nodeList.length) {
            index = 0;
        }

        $("#zTree_zTreeSearch .zTree-search-tip").html(index + 1 + "/" + zTree_nodeList.length);
        zTree_zTree.selectNode(zTree_nodeList[index]);
        $("#" + zTree_nodeList[index].tId + "_a").click();
    }

    // 上一个
    $("#zTree_zTreeSearch .icon-left").click(function () {
        var index = parseInt($("#zTree_zTreeSearch .zTree-search-tip").html().split("/")[0]);
        zTree_selectNode(--index - 1);
    });

    // 下一个
    $("#zTree_zTreeSearch .icon-right").click(function () {
        var index = parseInt($("#zTree_zTreeSearch .zTree-search-tip").html().split("/")[0]);
        zTree_selectNode(--index + 1);
    });
</script>
