<@com.html title="政策法规" import="layui,jquery,ueditor,common,font,main"/>
<body class="gtmap">
<style>
    .newContent {
        height: 400px;
    }
</style>
<div class="gt-container">
    <form action="" class="layui-form" id="newsForm">
    <#if view=="">
        <@toolbar show="save,print" />
    <#else>
    </#if>
    <#-- 存储隐藏值-->
        <input type="hidden" class="input-text" id="lawId" name="lawId" value="${laws.lawId!}">
        <input type="hidden" class="input-text" id="treeLinkId" name="treeLinkId" value="${laws.treeLinkId!}">

        <div class="gt-content">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    政策法规
                </div>
            </div>
            <table class="layui-table gt-special-table table-border">
                <tbody>
                <tr>
                    <td class="gt-td-title">政策法规类型</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="treeName" name="treeName" value="${laws.treeName!}">
                    </td>
                    <td class="gt-td-title">颁布日期</td>
                    <td class="pd0" colspan="2">
                        <#if laws.fpubDate??>
                            <input class="layui-input" type="text" id="fpubDate" name="fpubDate" value="${(laws.fpubDate!.now)?string('yyyy-MM-dd')}">
                        <#else>
                            <input class="layui-input" type="text" id="fpubDate" name="fpubDate" value="">
                        </#if>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">标  题</td>
                    <td colspan="8" >
                        <input class="layui-input" type="text" id="ftitle" name="ftitle" value="${laws.ftitle!}" lay-verify="required">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">主题词</td>
                    <td colspan="8" >
                        <input class="layui-input" type="text" id="fkeyword" name="fkeyword" value="${laws.fkeyword!}" lay-verify="required">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">发布单位</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="fpubDpt" name="fpubDpt" value="${laws.fpubDpt!}">
                    </td>
                    <td class="gt-td-title">信息来源</td>
                    <td class="pd0" colspan="2">
                        <input class="layui-input" type="text" id="finfoSource" name="finfoSource" value="${laws.finfoSource!}">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">文  号</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="docSymbol" name="docSymbol" value="${laws.docSymbol!}">
                    </td>
                    <td class="gt-td-title">效力级别</td>
                    <td class="pd0" colspan="2">
                        <input class="layui-input" type="text" id="effectLeve" name="effectLeve" value="${laws.effectLeve!}">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">摘  要</td>
                    <td colspan="8">
                        <textarea class="layui-textarea" id="remark" name="remark" lay-verify="content">${laws.remark!}</textarea>
                    </td>
                </tr>
                <tr>
                    <td colspan="9">
                        <script id="lawContent" name="lawContent" type="text/plain">${laws.lawContent!}</script>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </form>
</div>
</body>
<script type="text/javascript">
    //实例化编辑器
    var ue = UE.getEditor('lawContent');
    ue.ready(function () {
        //自定义请求参数
        ue.execCommand('serverparam', {
            'id': '${laws.lawId!}',
        });
        ue.queryCommandValue('serverparam');

        UE.Editor.prototype._bkGetActionUrl = UE.Editor.prototype.getActionUrl;
        UE.Editor.prototype.getActionUrl = function (action) {
            if (action = ue.getOpt("imageActionName")){
                return getRoot()+ ue.getOpt("imageActionName");
            }else if(action = ue.getOpt("fileActionName")){
                return getRoot()+ ue.getOpt("fileActionName");
            }
            else {
                return this._bkGetActionUrl.call(this.action);
            }
        }
    });
    layui.use(['form','laydate'], function() {
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;

        laydate.render({
            elem: '#fpubDate' //指定元素
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });

        //表单提交
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/laws/save",
                dataType: "json",
                data: $("#lawsForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.3,
                    })
                },
                complete: function () {
                },
                success: function (data) {
                    if (data.flag) {
                        layer.alert(data.message, {icon: 6});
                        $("#lawId").val(data.empty.lawId);
                        opener.loadInfo();
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }
                }
            });
        }
    });
</script>
</html>
