<@com.html title="收文列表" import="viewList,screen" />
<style>
    a:hover{
        color: #08c;
    }
</style>
<body class="gtmap">
<div class="gt-body">
    <div class="layui-row gt-toolbar">
        <div class="layui-col-xs12">
            <button class="layui-btn layui-btn-sm" type="button" id="archive">
                <i class="iconfont icon-guidang"></i> 归 档
            </button>
        </div>
    </div>
    <div class="gtmap-body">
        <div class="gtmap-cnt">
            <div class="menu-group">
                <form class="layui-form gt-form-group gt-form-bdgroup">
                    <div class="gt-new-form-item">
                        <div class="right-btnbox">
                            <div class="layui-btn layui-btn-sm">
                                <div onclick="loadInfo()"><i class="iconfont icon-search"></i>搜 索</div>
                            </div>
                        </div>
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        标题
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" id="receiveTitle" name="receiveTitle" lay-verify="required" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        密级
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <select id="emergency" name="emergency" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                        <option value=""></option>
                                        <option value="普通">普通</option>
                                        <option value="内部">内部</option>
                                        <option value="秘密">秘密</option>
                                        <option value="机密">机密</option>
                                        <option value="绝密">绝密</option>
                                    </select>
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        来文类别
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <select id="receiveType" name="receiveType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                        <option value=""></option>
                                        <option value="普通来文">普通来文</option>
                                        <option value="国土资源厅来文">国土资源厅来文</option>
                                        <option value="中央、省级来文">中央、省级来文</option>
                                        <option value="市人民政府来文">市人民政府来文</option>
                                        <option value="市各委、办、局来文">市各委、办、局来文</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="more-form">
                        <div class="gt-new-form-item">
                            <div class="left-form">
                                <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                    <label class="layui-form-label layui-form-label-sm">
                                        <div class="gt-label-text">
                                            来文单位
                                        </div>
                                    </label>
                                    <div class="layui-input-block ">
                                        <input type="text" id="fromUnit" name="fromUnit" lay-verify="required" placeholder="" autocomplete="off" class="layui-input layui-input-sm">
                                    </div>
                                </div>
                                <div class="layui-col-xs6 layui-col-sm6 layui-col-md4">
                                    <label class="layui-form-label layui-form-label-sm">
                                        <div class="gt-label-text">
                                            收文编号
                                        </div>
                                    </label>
                                    <div class="layui-input-block">
                                        <select id="receiveName" name="receiveName" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                            <option value=""></option>
                                            <option value="连自然资收字">连自然资收字</option>
                                            <option value="连自然资监强执">连自然资监强执</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="layui-col-xs6 layui-col-sm6 layui-col-md4">
                                    <label class="layui-form-label layui-form-label-sm">
                                        <div class="gt-label-text">
                                            公开范围
                                        </div>
                                    </label>
                                    <div class="layui-input-block">
                                        <select id="publishType" name="publishType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                            <option value=""></option>
                                            <option value="内网公开">内网公开</option>
                                            <option value="不公开">不公开</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
                <div class="menu-more" data-flag="down">
                    显示更多筛选条件
                </div>
            </div>
            <div class="tablebox">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        收文列表
                    </div>
                </div>
                <div id="table1">
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.onresize=initHeight;
        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/receive/findByPage',
                dataType: "json",
                where: {
                    "receiveTitle": $("#receiveTitle").val(),
                    "fromUnit": $("#fromUnit").val(),
                    "emergency": $("#emergency").val(),
                    "receiveType": $("#receiveType").val(),
                    "receiveName": $("#receiveName").val(),
                    "publishType": $("#publishType").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'receiveId', title: 'id', width:120, fixed: 'left', hide: true}
                    , {field: 'receiveTitle', title: '标题',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.receiveId + "')";
                                return "<a onclick=\"" + funStr + "\">"+d.receiveTitle+"</a>"
                            }}
                    , {field: 'fromUnit', title: '来文单位', width:320}
                    , {field: 'receiveDate', title: '收文日期', width:120,templet:"<div>{{layui.util.toDateString(d.receiveDate, 'yyyy-MM-dd')}}</div>"}
                    , {field: 'emergency', title: '密级', width:120}
                    , {field: 'receiveType', title: '来文类别', width:300}
                ]],
                page: true,
                /** --------------- table加载完后的回调----------*/
                done: function(res, curr, count){
                    $('.layui-table-view td[data-field="receiveTitle"]').on({
                        mouseenter: function () {
                            var xmmc = $(this).text();
                            tips = layer.tips(
                                    "<span style='height: 400px;width:400px;color:#000;font-weight: bolder'>"+
                                    "<span style='text-align: left'>标题："+$.trim(xmmc)+"</span>"+
                                    "</span>", this, {
                                        tips: [3, '#fff'],
                                        time: 0,
                                        // area: 'auto',
                                        maxWidth: 500
                                    });
                        },
                        mouseleave: function () {
                            layer.close(tips);
                        }
                    });
                    //渲染收藏实例
                    $.each($("[data-content=collection] i"),function () {
                        $(this).parent('div').addClass("active");
                    });
//                    $('#todo-task span', window.parent.document).html('('+count+')');
                }
            });
        };

        //跳往编辑页面
        window.goViewProject = function (id) {
            window.open("${base}/receive/index?view=true&processInsId="+id);
        };

        //初始化查询
        loadInfo();

        window.deleteReceive = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                $("[name=checkbox]:checkbox").each(function (i, e) {
                    if ($(e).prop("checked")) {
                        ids.push($(e).val());
                    }
                });
                if (ids.length == 0) {
                    // layer.msg("请选择需要删除的数据！",{icon:2,time:2000});
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/receive/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除）
        $("#del").click(function (e) {
            deleteReceive();
        });

        window.archive = function () {
            var ids = [];
            var checkStatus = table.checkStatus('idTest')
                    ,data = checkStatus.data;
            for(var i=0;i<data.length;i++){
                ids.push(data[i].receiveId);
            }
            if (ids.length == 0) {
                layer.msg('请勾选要归档的数据', function(){
                    //关闭后的操作
                });
                return;
            }
            $.ajax({
                type : "post",
                url : "${base}/archive/receive",
                traditional: true,
                data : {"ids" : ids,"clientId":"officeAut"},
                beforeSend: function () {
                    layer.msg('正在归档...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                success : function (data) {
                    if(data.success){
                        layer.msg(data.msg, {icon: 1, time: 2000});
                        // 刷新数据
                        //loadInfo();
                    }else {
                        layer.msg(data.msg, {icon: 0, time: 2000});
                    }

                }
            });
        };


        //点击事件（归档）
        $("#archive").click(function (e) {
            archive();
        });

        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        })
        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-32;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
