<@com.html title="收文办文单" import="layui,common,font,main,sign,formCenter"/>
<body class="gtmap">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
    .border-t{border-top-color: red!important;}
    .border-b{border-bottom-color: red!important;}
    .border-l{border-left-color: red!important;}
    .border-r{border-right-color: red!important;}
</style>
<div class="gt-container">
    <form action="" class="layui-form" id="receiveForm">
        <#if view=="">
            <@toolbar show="save,print" />
        <#else>
        </#if>

        <#-- 存储隐藏值-->
        <input type="hidden" id="receiveId" name="receiveId" value="${receive.receiveId!}" id="receiveId" >
        <input type="hidden" id="view" name="view" value="${view!}"/>

        <div class="gt-content">
            <div class="gt-table-header">
                <div class="gt-table-title">
                    <h3 style="color: red">收文办文单</h3>
                </div>
            </div>
            <table class="layui-table gt-special-table table-border">
                <tbody>
                <tr>
                    <td class="gt-td-title">收文编号</td>
                    <td  colspan="2" style="border-right: none">
                        <select id="receiveName" name="receiveName" lay-filter="receivebh">
                            <option value="连自然资发"<#if receive.receiveName?? && receive.receiveName=='连自然资发'>selected </#if>>连自然资发</option>
                            <option value="连自然资党组"<#if receive.receiveName?? && receive.receiveName=='连自然资党组'>selected </#if>>连自然资党组</option>
                            <option value="连自然资复"<#if receive.receiveName?? && receive.receiveName=='连自然资复'>selected </#if>>连自然资复</option>
                            <option value="连自然资函"<#if receive.receiveName?? && receive.receiveName=='连自然资函'>selected </#if>>连自然资函</option>
                            <option value="连自然资信"<#if receive.receiveName?? && receive.receiveName=='连自然资信'>selected </#if>>连自然资信</option>
                            <option value="连自然资监案移"<#if receive.receiveName?? && receive.receiveName=='连自然资监案移'>selected </#if>>连自然资监案移</option>
                            <option value="连自然资监财（物）移"<#if receive.receiveName?? && receive.receiveName=='连自然资监财（物）移'>selected </#if>>连自然资监财（物）移</option>
                            <option value="连自然资监罚"<#if receive.receiveName?? && receive.receiveName=='连自然资监罚'>selected </#if>>连自然资监罚</option>
                            <option value="连自然资监改"<#if receive.receiveName?? && receive.receiveName=='连自然资监改'>selected </#if>>连自然资监改</option>
                            <option value="连自然资监履催"<#if receive.receiveName?? && receive.receiveName=='连自然资监履催'>selected </#if>>连自然资监履催</option>
                            <option value="连自然资监强执"<#if receive.receiveName?? && receive.receiveName=='连自然资监强执'>selected </#if>>连自然资监强执</option>
                            <option value="连自然资监行处建"<#if receive.receiveName?? && receive.receiveName=='连自然资监行处建'>selected </#if>>连自然资监行处建</option>
                        </select>
                    </td>
                    <td style="border-right: none;border-left: none;">
                        〔<input style="width:58%!important;padding-left: 0;text-align: center;display: inline-block;" class="layui-input" type="text" id="receiveYear" name="receiveYear" value="${receive.receiveYear!}">〕
                    </td>
                    <td style="border-left: none" colspan="2">
                        <input style="width:20%!important;padding-left: 0;text-align: center;display: inline-block;" class="layui-input" type="text" id="receiveNo" name="receiveNo" value="${receive.receiveNo!}">&nbsp;号
                    </td>
                    <td class="gt-td-title">来文类别</td>
                    <td colspan="2">
                        <select id="receiveType" name="receiveType" >
                            <option value="普通来文"<#if receive.receiveType?? && receive.receiveType=='普通来文'>selected </#if>>普通来文</option>
                            <option value="国土资源厅来文"<#if receive.receiveType?? && receive.receiveType=='国土资源厅来文'>selected </#if>>国土资源厅来文</option>
                            <option value="中央、省级来文"<#if receive.receiveType?? && receive.receiveType=='中央、省级来文'>selected </#if>>中央、省级来文</option>
                            <option value="市人民政府来文"<#if receive.receiveType?? && receive.receiveType=='市人民政府来文'>selected </#if>>市人民政府来文</option>
                            <option value="市各委、办、局来文"<#if receive.receiveType?? && receive.receiveType=='市各委、办、局来文'>selected </#if>>市各委、办、局来文</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">来文文号</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="originNo" name="originNo" value="${receive.originNo!}">
                    </td>
                    <td class="gt-td-title">公开范围</td>
                    <td class="pd0" colspan="2">
                        <select id="publishType" name="publishType">
                            <option value="内网公开"<#if receive.publishType?? && receive.publishType=='内网公开'>selected </#if>>内网公开</option>
                            <option value="不公开"<#if receive.publishType?? && receive.publishType=='不公开'>selected </#if>>不公开</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title"><span class="red-text">*</span>标  题</td>
                    <td colspan="8" >
                        <input class="layui-input" type="text" id="receiveTitle" name="receiveTitle" value="${receive.receiveTitle!}" lay-verify="required">
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">来文单位</td>
                    <td colspan="5">
                        <input class="layui-input" type="text" id="fromUnit" name="fromUnit" value="${receive.fromUnit!}">
                    </td>
                    <td class="gt-td-title">紧急程度</td>
                    <td class="pd0" colspan="2">
                        <select id="receiveGrade" name="receiveGrade">
                            <option value="平件"<#if receive.receiveGrade?? && receive.receiveGrade=='平件'>selected </#if>>平件</option>
                            <option value="急件"<#if receive.receiveGrade?? && receive.receiveGrade=='急件'>selected </#if>>急件</option>
                            <option value="紧急"<#if receive.receiveGrade?? && receive.receiveGrade=='紧急'>selected </#if>>紧急</option>
                            <option value="特急"<#if receive.receiveGrade?? && receive.receiveGrade=='特急'>selected </#if>>特急</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">接收日期</td>
                    <td colspan="5">
                        <input class="layui-input layui-date" type="text" id="receiveDate" name="receiveDate" value="${(receive.receiveDate!.now)?string('yyyy-MM-dd')}">
                    </td>
                    <td class="gt-td-title">密  级</td>
                    <td class="pd0" colspan="2">
                        <select id="emergency" name="emergency">
                            <option value="普通"<#if receive.emergency?? && receive.emergency=='普通'>selected </#if>>普通</option>
                            <option value="内部"<#if receive.emergency?? && receive.emergency=='内部'>selected </#if>>内部</option>
                            <option value="秘密"<#if receive.emergency?? && receive.emergency=='秘密'>selected </#if>>秘密</option>
                            <option value="机密"<#if receive.emergency?? && receive.emergency=='机密'>selected </#if>>机密</option>
                            <option value="绝密"<#if receive.emergency?? && receive.emergency=='绝密'>selected </#if>>绝密</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title">备  注</td>
                    <td colspan="8">
                        <textarea class="layui-textarea" id="remark" name="remark" lay-verify="content">${receive.remark!}</textarea>
                    </td>
                </tr>
                <tr>
                    <td class="gt-td-title" >承办意见</td>
                    <td colspan="8" class="gtmapSign" id="cbyj" signKey="cbyj" userName="${userName!}" noOpinion="false" multiSign="true" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                <tr>
                    <td class="gt-td-title" >办公室意见</td>
                    <td colspan="8" class="gtmapSign" id="bgsyj" signKey="bgsyj" userName="${userName!}" noOpinion="false" multiSign="true" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                <tr>
                    <td class="gt-td-title">办公室主任<br>审  批</td>
                    <td colspan="8" class="gtmapSign" id="bgszr" signKey="bgszr" userName="${userName!}" noOpinion="false" multiSign="true" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                <tr>
                    <td class="gt-td-title">分管领导<br>审  批</td>
                    <td colspan="8" class="gtmapSign" id="fgld" signKey="fgld" userName="${userName!}" noOpinion="false" multiSign="true" style="padding: 0px!important;" disabled="disabled"></td>
                </tr>
                </tbody>
            </table>
        </div>
    </form>
</div>
</body>
<script type="text/javascript">
    layui.use([ 'jquery','form','element','laydate'], function(){
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;

        //收文编号
        var reno = $("[name='receiveNo']").val();
        var reyear = $("[name='receiveYear']").val();
        var rename = $("select[name='receiveName']").val();
        if(reno==null||reno==""){
            $.get("receiveNo",{name:rename,year:reyear},function(result){
                $("[name='receiveNo']").val(result);
            });
        }
        //表单红色边框
        $('.table-border tr:first-of-type td').addClass('border-t');
        $('.table-border tr:last-of-type td').addClass('border-b');
        $('.table-border tr>td:first-of-type').addClass('border-l');
        $('.table-border tr>td:last-of-type').addClass('border-r');
        //监听下拉
        form.on('select(receivebh)', function(data) {
            var name = $("select[name='receiveName']").val();
            var year = $("[name='receiveYear']").val();
            if(rename!=name) {
                $.get("receiveNo", {name: name, year: year}, function (result) {
                    $("[name='receiveNo']").val(result);
                });
                form.render('select');
            }else {
                $("[name='receiveNo']").val(reno);
            }
        });

        laydate.render({
            elem: '#receiveDate', //指定元素
            //range: true
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });


        /**
         * 表单提交
         */
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/receive/save",
                dataType: "json",
                data: $("#receiveForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#receiveId").val(data.empty.receiveId);
                            //刷新列表
//                            opener.loadInfo();
                        });
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }

                }
            });
            saveAll();
        }

        $(function(){
            var view = $("#view").val();
            if(view!=""){
                $(".gt-container").css('top',"0px");
            }else {
            }
            var formStateId = getQueryString("formStateId");
            setElementAttrByFormState(formStateId);
        });
        /**
         * 获取url参数
         * @param key 参数名
         * @returns
         */
        function getQueryString(key) {
            var reg = new RegExp("(^|&)" + key + "=([^&]*)(&|$)");
            var r = location.search.substr(1).match(reg);
            if (r != null) {
                return unescape(r[2]);
            }
            return null;
        }
    });
</script>
</html>
