<@com.html title="发文列表" import="viewList,screen" />
<style>
    a:hover{
        color: #08c;
    }
</style>
<body class="gtmap">
<div class="gt-body">
    <div class="layui-row gt-toolbar">
        <div class="layui-col-xs12">
            <button class="layui-btn layui-btn-sm" type="button" id="archive">
                <i class="iconfont icon-guidang"></i> 归 档
            </button>
        </div>
    </div>
    <div class="gtmap-body">
        <div class="gtmap-cnt">
            <div class="menu-group">
                <form class="layui-form gt-form-group gt-form-bdgroup">
                    <div class="gt-new-form-item">
                        <div class="right-btnbox">
                            <div class="layui-btn layui-btn-sm">
                                <div onclick="loadInfo()"><i class="iconfont icon-search" ></i>搜 索</div>
                            </div>
                        </div>
                        <div class="left-form">
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        标题
                                    </div>
                                </label>
                                <div class="layui-input-block ">
                                    <input type="text" id="dispatchTitle" name="dispatchTitle" lay-verify="required" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        发文编号
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <input type="text" id="serialNo" name="serialNo" lay-verify="required" autocomplete="off" class="layui-input layui-input-sm">
                                </div>
                            </div>
                            <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                <label class="layui-form-label layui-form-label-sm">
                                    <div class="gt-label-text">
                                        行文类别
                                    </div>
                                </label>
                                <div class="layui-input-block">
                                    <select id="docType" name="docType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                        <option value=""></option>
                                        <option value="下行文">下行文</option>
                                        <option value="平行文">平行文</option>
                                        <option value="上行文">上行文</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="more-form">
                        <div class="gt-new-form-item">
                            <div class="left-form">
                                <div class="layui-col-lg4 layui-col-xs6 layui-col-sm6 layui-col-md4">
                                    <label class="layui-form-label layui-form-label-sm">
                                        <div class="gt-label-text">
                                            公开范围
                                        </div>
                                    </label>
                                    <div class="layui-input-block ">
                                        <select id="publishType" name="publishType" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                            <option value=""></option>
                                            <option value="内网公开">内网公开</option>
                                            <option value="不公开">不公开</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="layui-col-xs6 layui-col-sm6 layui-col-md4">
                                    <label class="layui-form-label layui-form-label-sm">
                                        <div class="gt-label-text">
                                            发文主体
                                        </div>
                                    </label>
                                    <div class="layui-input-block">
                                        <select id="dispatchMainbody" name="dispatchMainbody" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                            <option value=""></option>
                                            <option value="局发文">局发文</option>
                                            <option value="局党组发文">局党组发文</option>
                                            <option value="局纪检组发文">局纪检组发文</option>
                                            <option value="其他">其他</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="layui-col-xs6 layui-col-sm6 layui-col-md4">
                                    <label class="layui-form-label layui-form-label-sm">
                                        <div class="gt-label-text">
                                            紧急程度
                                        </div>
                                    </label>
                                    <div class="layui-input-block">
                                        <select id="exigencyDegree" name="exigencyDegree" lay-verify="required" lay-filter="aihao" class="layui-select-sm">
                                            <option value=""></option>
                                            <option value="平件">平件</option>
                                            <option value="急件">急件</option>
                                            <option value="紧急">紧急</option>
                                            <option value="特急">特急</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
                <div class="menu-more" data-flag="down">
                    显示更多筛选条件
                </div>
            </div>
            <div class="tablebox">
                <div class="gt-table-header">
                    <div class="gt-table-title">
                        发文列表
                    </div>
                </div>
                <div id="table1">
                </div>
            </div>
        </div>
    </div>
</div>
</body>

<script>
    //注意：导航 依赖 element 模块，否则无法进行功能性操作
    layui.use([ 'jquery','form','laypage','table','element','layer','code'], function() {
        var form = layui.form,
                laypage = layui.laypage,
                table=layui.table,
                element=layui.element,
                $ = layui.$;
        var tableHeight=initHeight("init");
        window.onresize=initHeight;

        window.loadInfo = function() {
            table.render({
                elem: '#table1',
                url: '${base}/dispatch/findByPage',
                dataType: "json",
                where: {
                    "dispatchTitle": $("#dispatchTitle").val(),
                    "serialNo": $("#serialNo").val(),
                    "docType": $("#docType").val(),
                    "publishType": $("#publishType").val(),
                    "dispatchMainbody": $("#dispatchMainbody").val(),
                    "exigencyDegree": $("#exigencyDegree").val()
                },
                height: 'full-' + tableHeight,
                id: 'idTest',
                cols: [[
                    {type: 'checkbox', fixed: 'left'}
                    , {field: 'dispatchId', title: 'dispatchId', width:120, fixed: 'left', hide: true}
                    , {field: 'dispatchTitle', title: '标题',templet:
                            function (d) {
                                var funStr ="goViewProject('" + d.dispatchId + "')";
                                return "<a onclick=\"" + funStr + "\">"+d.dispatchTitle+"</a>"
                            }}
                    , {field: 'serialNo', title: '发文编号', width:320}
                    , {field: 'docType', title: '发文类型', width:200}
                    , {field: 'publishType', title: '公开范围', width:200}
                    , {field: 'draftDate', title: '发布日期', width:120,templet:"<div>{{layui.util.toDateString(d.draftDate, 'yyyy-MM-dd')}}</div>"}
                ]],
                page: true,
                /** --------------- table加载完后的回调----------*/
                done: function(res, curr, count){
                    $('.layui-table-view td[data-field="dispatchTitle"]').on({
                        mouseenter: function () {
                            var xmmc = $(this).text();
                            tips = layer.tips(
                                    "<span style='height: 400px;width:400px;color:#000;font-weight: bolder'>"+
                                    "<span style='text-align: left'>标题："+$.trim(xmmc)+"</span>"+
                                    "</span>", this, {
                                        tips: [3, '#fff'],
                                        time: 0,
                                        // area: 'auto',
                                        maxWidth: 500
                                    });
                        },
                        mouseleave: function () {
                            layer.close(tips);
                        }
                    });
                    //渲染收藏实例
                    $.each($("[data-content=collection] i"),function () {
                        $(this).parent('div').addClass("active");
                    });
//                    $('#todo-task span', window.parent.document).html('('+count+')');
                }
            });
        };

        //跳往编辑页面
        window.goViewProject=function(id){
            window.open("${base}/dispatch/index?view=true&processInsId="+id);
        };

        //初始化查询
        loadInfo();

        window.deleteDispatch = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                $("[name=checkbox]:checkbox").each(function (i, e) {
                    if ($(e).prop("checked")) {
                        ids.push($(e).val());
                    }
                });
                if (ids.length == 0) {
                    // layer.msg("请选择需要删除的数据！",{icon:2,time:2000});
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/dispatch/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 2000});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //点击事件（删除）
        $("#del").click(function (e) {
            deleteDispatch();
        });

        window.archive = function () {
            var ids = [];

            var checkStatus = table.checkStatus('idTest')
                    ,data = checkStatus.data;
            for(var i=0;i<data.length;i++){
                ids.push(data[i].dispatchId);
            }
            if (ids.length == 0) {
                layer.msg('请勾选要归档的数据', function(){
                    //关闭后的操作
                });
                return;
            }

            $.ajax({
                type : "post",
                url : "${base}/archive/dispatch",
                traditional: true,
                data : {"ids" : ids,"clientId":"officeAut"},
                beforeSend: function () {
                    layer.msg('正在归档...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                success : function (data) {
                    if(data.success){
                        layer.msg(data.msg, {icon: 1, time: 2000});
                        // 刷新数据
                        //loadInfo();
                    }else {
                        layer.msg(data.msg, {icon: 0, time: 2000});
                    }

                }
            });
        };

        //点击事件（归档）
        $("#archive").click(function (e) {
            archive();
        });

        $(".menu-more").click(function(){
            var flag=$(this).attr("data-flag"),newsTop;
            if(flag=="up"){
                $(this).attr("data-flag","down");
                $(this).parents(".menu-group").children(".layui-form").css("height","30px");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","none");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("显示更多筛选条件");
                initHeight();
            }else{
                $(this).attr("data-flag","up");
                $(this).parents(".menu-group").children(".layui-form").css("height","auto");
                $(this).parents(".menu-group").children(".layui-form").children(".more-form").css("display","block");
                newsTop=$(".menu-group").height()+21;
                $(".news-content").css('top',newsTop);
                $(".menu-more").html("折叠更多筛选条件");
                initHeight();
            }

        })
        function initHeight(flag){
//		  		client().width + "    "+ client().height;
            var vheight=$(".menu-group").height()+$(".gt-toolbar").height()+$(".gt-table-header").height()+22+30+20;
            var bodyHeight=client().height-$(".gt-toolbar").height()-32;
            $(".gtmap-body").height(bodyHeight);

            console.log(bodyHeight);

            console.log(vheight);
            if(flag=="init"){
                return vheight;
            }else{
                table.reload('idTest', {
                    height: "full-"+vheight
                });
            }
        }
    });
</script>
</html>
