/** navbar.js By Beginner Emain:zheng_jinfan@126.com HomePage:http://www.zhengjinfan.cn */
layui.define(['element'], function (exports) {
    "use strict";
    var $ = layui.jquery,
        layer = parent.layer === undefined ? layui.layer : parent.layer,
//      element = layui.element(),
        cacheName = 'tb_navbar';

    var Navbar = function () {
		/**
		 *  默认配置 
		 */
        this.config = {
            elem: undefined, //容器
            data: undefined, //数据源
            url: undefined, //数据源地址
            type: 'GET', //读取方式
            cached: false, //是否使用缓存
            spreadOne: false //设置是否只展开一个二级菜单
        };
        this.v = '1.0.0';
    };
    //渲染
    Navbar.prototype.render = function () {
        var _that = this;
        var _config = _that.config;
        var $container;
        if (typeof (_config.elem) === 'string') {
            $container = $('' + _config.elem + '');
        }
        if (typeof (_config.elem) === 'object') {
            $container = _config.elem;
        }
        if (_config.data !== undefined && typeof (_config.data) === 'object') {
            var html = getHtml(_config.data);
            $container.html(html);
//          element.init();
            _that.config.elem = $container;
        } else {
            if (_config.cached) {
                var cacheNavbar = layui.data(cacheName);
                if (cacheNavbar.navbar === undefined) {
                    $.ajax({
                        type: _config.type,
                        url: _config.url,
                        async: false, //_config.async,
                        dataType: 'json',
                        success: function (result, status, xhr) {
                            //添加缓存
                            layui.data(cacheName, {
                                key: 'navbar',
                                value: result
                            });
                            var html = getHtml(result);
                            $container.html(html);
//                          element.init();
                        },
                        error: function (xhr, status, error) {
                        },
                        complete: function (xhr, status) {
                            _that.config.elem = $container;
                        }
                    });
                } else {
                    var html = getHtml(cacheNavbar.navbar);
                    $container.html(html);
//                  element.init();
                    _that.config.elem = $container;
                }
            } else {
                //清空缓存
                layui.data(cacheName, null);
                $.ajax({
                    type: _config.type,
                    url: _config.url,
                    async: false, //_config.async,
                    dataType: 'json',
                    success: function (result, status, xhr) {
                        var html = getHtml(result);
                        $container.html(html);
//                      element.init();
                    },
                    error: function (xhr, status, error) {
                    },
                    complete: function (xhr, status) {
                        _that.config.elem = $container;
                    }
                });
            }
        }

        //只展开一个二级菜单
        if (_config.spreadOne) {
            var $ul = $container.children('ul');
            $ul.find('li.layui-nav-item').each(function () {
                $(this).on('click', function () {
                    $(this).siblings().removeClass('layui-nav-itemed');
                });
            });
        }
        return _that;
    };
	/**
	 * 配置Navbar
	 * @param {Object} options
	 */
    Navbar.prototype.set = function (options) {
        var that = this;
        that.config.data = undefined;
        $.extend(true, that.config, options);
        return that;
    };
	/**
	 * 绑定事件
	 * @param {String} events
	 * @param {Function} callback
	 */
    Navbar.prototype.on = function (events, callback) {
        var that = this;
        if (that.config.el === undefined && that.config.el === null) {
            that.config.el = that.info.el
        }
        var _con = that.config.el;
        if (typeof (events) !== 'string') {
            common.throwError('SideBar error:事件名配置出错，请参考API文档.');
        }
        var lIndex = events.indexOf('(');
        var eventName = events.substr(0, lIndex);
        var filter = events.substring(lIndex + 1, events.indexOf(')'));
        //点击事件
        if (eventName === 'click') {
        	
            if (_con.attr('lay-filter') !== undefined) {
                _con.find('.layui-side-scroll li').each(function () {
                    var $this = $(this);
                    //一级列表
                    if ($this.find('dl').length == 0) {
                        $this.on('click', function () {
                        	
                            var $a = $this.children('a');
                            var href = $a.data('url');
                            var icon = $a.children('i:first').data('icon');
                            var title = $a.children('cite').text();
                            var data = {
                                elem: $a,
                                field: {
                                    href: href,
                                    icon: icon,
                                    title: title
                                }
                            }
                            callback(data);
                        });
                        //二级列表
                    } else if ($this.find('dl').length > 0) {
                        var $dd = $this.find('dd').each(function () {
                            if(!$(this).children("dl").length>0){
                                $(this).on('click', function () {
                                    var $a = $(this).children('a');
                                    var href = $a.data('url');
                                    var icon = $a.children('i:first').data('icon');
                                    var title = $a.children('cite').text();
                                    var data = {
                                        elem: $a,
                                        field: {
                                            href: href,
                                            icon: icon,
                                            title: title
                                        }
                                    }
                                    callback(data);
                                });
                            }
                        });
                        //三级列表
                    } else if ($this.find('dd').children('dl').length > 0) {
                        var $dd = $this.find('dd').children('dl').find('dd').each(function () {
                            $(this).on('click', function () {
                                var $a = $(this).children('a');
                                var href = $a.data('url');
                                var icon = $a.children('i:first').data('icon');
                                var title = $a.children('cite').text();
                                var data = {
                                    elem: $a,
                                    field: {
                                        href: href,
                                        icon: icon,
                                        title: title
                                    }
                                }
                                callback(data);
                            });
                        })
                    }
                });
            }
        }
    };
	/**
	 * 清除缓存
	 */
    Navbar.prototype.cleanCached = function () {
        layui.data(cacheName, null);
    };
	    /**
     * 获取html字符串
     * @param {Object} data
     */
    function getHtml(data) {
        //debugger;
        var ulHtml = '<div class="layui-side-scroll"><ul class="layui-nav layui-nav-tree beg-navbar">';
        for (var i = 0; i < data.length; i++) {
            if (data[i].spread) {
            	if(data[i].children==""||data[i].children==null||data[i].children=="null"||data[i].children=="undefined"){
            		if(i=="0"){
            			ulHtml += '<li class="layui-nav-item layui-this">';
            		}else{
            			ulHtml += '<li class="layui-nav-item">';
            		}
            	}else{
            		ulHtml += '<li class="layui-nav-item layui-nav-itemed">';
            	}
                
            } else {
            	if(i=="0"){
        			ulHtml += '<li class="layui-nav-item layui-this">';
        		}else{
        			ulHtml += '<li class="layui-nav-item">';
        		}
                
            }
            var dataUrl = (data[i].href !== undefined && data[i].href !== '') ? 'data-url="' + data[i].href + '"' : '';
//      	ulHtml += '<a href="javascript:;">';
        	ulHtml += '<a href="javascript:;" ' + dataUrl + '>';
            if (data[i].icon !== undefined && data[i].icon !== '') {
                if (data[i].icon.indexOf('fa-') !== -1) {
                    ulHtml += '<i class="fa ' + data[i].icon + '" aria-hidden="true" data-icon="' + data[i].icon + '"></i>';
                } else if(data[i].icon.indexOf('layui-')!== -1){
                    ulHtml += '<i class="layui-icon" data-icon="' + data[i].icon + '">' + data[i].icon + '</i>';
                } else if(data[i].icon.indexOf('icon-')!== -1){
                	if(data[i].icon.indexOf('iconfont')!== -1){
                		ulHtml += '<i class="'+data[i].icon+'" data-icon="' + data[i].icon + '"></i>';
                	}else{
                		ulHtml += '<i class="iconfont '+data[i].icon+'" data-icon="' + data[i].icon + '"></i>';
                	}
                }else{
                	ulHtml += '<i class="'+data[i].icon+'" data-icon="' + data[i].icon + '"></i>';
                }
            }else{
            	ulHtml += '<i class="iconfont icon-tongyong'+data[i].icon+'" data-icon="' + data[i].icon + '"></i>';
            }
            ulHtml += '<cite>' + data[i].title + '</cite>';
//              ulHtml += '<span class="layui-icon layui-icon-right"></span>';
            ulHtml += '</a>';
            if (data[i].children !== undefined && data[i].children !== null && data[i].children.length > 0) {
                ulHtml += '<dl class="layui-nav-child">'
                for (var j = 0; j < data[i].children.length; j++) {
                    ulHtml += '<dd title="' + data[i].children[j].title + '">';
                    if (data[i].children[j].href !== undefined) {
                        ulHtml += '<a href="javascript:;" data-url="' + data[i].children[j].href + '">';
                    } else {
                        ulHtml += '<a href="javascript:;">';
                    }
                    if (data[i].children[j].icon !== undefined && data[i].children[j].icon !== '') {
                        if (data[i].children[j].icon.indexOf('fa-') !== -1) {
                            ulHtml += '<i class="fa ' + data[i].children[j].icon + '" data-icon="' + data[i].children[j].icon + '" aria-hidden="true"></i>';
                        }  else if(data[i].icon.indexOf('layui-')!== -1){
	                        ulHtml += '<i class="layui-icon" data-icon="' + data[i].children[j].icon + '">' + data[i].children[j].icon + '</i>';
	                    }else{
	                    	ulHtml += '<i class="'+data[i].children[j].icon+'" data-icon="' + data[i].children[j].icon + '"></i>';
	                    }
                    }
                    ulHtml += '<cite>' + data[i].children[j].title + '</cite>';
                    ulHtml += '</a>';
                    if (data[i].children[j].children !== undefined && data[i].children[j].children !== null && data[i].children[j].children.length > 0) {
                        ulHtml += '<dl class="layui-nav-child">';
                        for (var k = 0; k < data[i].children[j].children.length; k++) {
                            ulHtml += '<dd title="' + data[i].children[j].children[k].title + '">';
                            ulHtml += '<a href="javascript:;" data-url="' + data[i].children[j].children[k].href + '">';
                            if (data[i].children[j].icon !== undefined && data[i].children[j].icon !== '') {
                                if (data[i].children[j].children[k].icon.indexOf('fa-') !== -1) {
                                    ulHtml += '<i class="fa ' + data[i].children[j].children[k].icon + '" data-icon="' + data[i].children[j].children[k].icon + '" aria-hidden="true"></i>';
                                }  else if(data[i].icon.indexOf('layui-')!== -1){
			                        ulHtml += '<i class="layui-icon" data-icon="' + data[i].children[j].children[k].icon + '">' + data[i].children[j].children[k].icon + '</i>';
			                    }else{
			                    	ulHtml += '<i class="'+data[i].children[j].children[k].icon+'" data-icon="' + data[i].children[j].children[k].icon + '"></i>';
			                    }
                            }
                            ulHtml += '<cite>' + data[i].children[j].children[k].title + '</cite>';
                            ulHtml += '</a></dd>';
                        }
                        ulHtml += '</dl>';
                    }

                    ulHtml += '</dd>';
                }
                ulHtml += '</dl>';
            } 
//          else {
//              var dataUrl = (data[i].href !== undefined && data[i].href !== '') ? 'data-url="' + data[i].href + '"' : '';
//              ulHtml += '<a href="javascript:;" ' + dataUrl + '>';
//              if (data[i].icon !== undefined && data[i].icon !== '') {
//                  if (data[i].icon.indexOf('fa-') !== -1) {
//                      ulHtml += '<i class="fa ' + data[i].icon + '" aria-hidden="true" data-icon="' + data[i].icon + '"></i>';
//                  } else if(data[i].icon.indexOf('layui-')!== -1){
//                      ulHtml += '<i class="layui-icon" data-icon="' + data[i].icon + '">' + data[i].icon + '</i>';
//                  }else{
//                  	ulHtml += '<i class="'+data[i].icon+'" data-icon="' + data[i].icon + '"></i>';
//                  }
//              }
//              ulHtml += '<cite>' + data[i].title + '</cite>';
//              
////              ulHtml += '<span class="layui-icon layui-icon-right"></span>';
//              ulHtml += '</a>';
//          }
            ulHtml += '</li>';
        }
        ulHtml += '</ul></div>';

        return ulHtml;
    }

    var navbar = new Navbar();

    exports('navbar', function (options) {
        return navbar.set(options);
    });
});