// 日期格式化
Date.prototype.Format = function (fmt) { //author: meizz

    var o = {
        "M+": this.getMonth() + 1, //月份
        "d+": this.getDate(), //日
        "H+": this.getHours(), //小时
        "m+": this.getMinutes(), //分
        "s+": this.getSeconds(), //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds() //毫秒
    };
    if (/(y+)/.test(fmt))
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
}
// String时间 与 当前时间 相减
function subStrDate(oldDate) {
    var newDate = new Date().Format("yyyy-MM-dd HH:mm:ss");
    var oldDateArr = oldDate.split(" ");
    var newDateArr = newDate.split(" ");
    if (oldDateArr[0] == newDateArr[0]) {
        var oldHms = oldDateArr[1].split(":");
        var newHms = newDateArr[1].split(":");
        if (oldHms[0] != newHms[0]) {
            return (parseInt(newHms[0]) - parseInt(oldHms[0])) + "小时前";
        }
        if (oldHms[1] != newHms[1]) {
            return (parseInt(newHms[1]) - parseInt(oldHms[1])) + "分钟前";
        }
        if (oldHms[2] != newHms[2]) {
            return (parseInt(newHms[2]) - parseInt(oldHms[2])) + "秒前";
        }
    } else {
        var oldDay = oldDateArr[0].split("-");
        var newDay = newDateArr[0].split("-");
        return (parseInt(newDay[2]) - parseInt(oldDay[2])) + "天前";
    }
}
// 时间大小比较(String) time1是否大于tim2?
function compareTime(time1, time2) {
    var date1 = NewDateYMDHMS(time1);
    var date2 = NewDateYMDHMS(time2);
    return date1 >= date2;
}
//数字比较判等
function compareNumber(arg1,arg2,arg3){
    return Number(arg3) == Number(arg1) + Number(arg2);
}
// 年月日格式
function NewDateYMD(str) {
    if (typeof str == "number") {
        return new Date(str);
    } else if (typeof str == "object") {
        return str;
    }  else {
        //首先将日期分隔 ，获取到日期部分 和 时间部分
        var day = str.split(' ');
        //获取日期部分的年月日
        var days = day[0].split('-');
        //获取当前date类型日期
        var date = new Date();
        //给date赋值  年月日
        date.setUTCFullYear(days[0], days[1] - 1, days[2]);
        return date;
    }
}

// 年月日 时分秒格式
function NewDateYMDHMS(str) {
    if (typeof str == "number") {
        return new Date(str);
    } else if (typeof str == "object") {
        return str;
    }  else {
        //首先将日期分隔 ，获取到日期部分 和 时间部分
        var day = str.split(' ');
        //获取日期部分的年月日
        var days = day[0].split('-');
        //获取当前date类型日期
        var date = new Date();
        //给date赋值  年月日
        date.setUTCFullYear(days[0], days[1] - 1, days[2]);
        if (day.length > 1) {
            //获取时间部分的 时分秒
            var mi = day[day.length - 1].split(':');
            //给date赋值 时分秒  首先转换utc时区 ：+8
            //if (mi.length = 2) {
            //    mi.push('00');
            //} 不知道什么意思 先注释掉了。。。
            date.setUTCHours(mi[0] - 8, mi[1], mi[2]);
        }
        return date;
    }
}

// 浮点数乘法
function accMul(arg1, arg2) {
    var m = 0, s1 = arg1.toString(), s2 = arg2.toString();
    try {
        m += s1.split('.')[1].length
    } catch (e) {
    }
    try {
        m += s2.split('.')[1].length
    } catch (e) {
    }
    return Number(s1.replace('.', '')) * Number(s2.replace('.', '')) / Math.pow(10, m);
}
// 浮点数除法
function accDiv(arg1, arg2) {
    var t1 = 0, t2 = 0, r1, r2;
    try {
        t1 = arg1.toString().split('.')[1].length
    } catch (e) {
    }
    try {
        t2 = arg2.toString().split('.')[1].length
    } catch (e) {
    }
    with (Math) {
        r1 = Number(arg1.toString().replace('.', ''));
        r2 = Number(arg2.toString().replace('.', ''));
        return (r1 / r2) * pow(10, t2 - t1);
    }
}
// 加法
function accAdd(arg1, arg2) {
    var r1, r2, m, c;
    try {
        r1 = arg1.toString().split(".")[1].length;
    }
    catch (e) {
        r1 = 0;
    }
    try {
        r2 = arg2.toString().split(".")[1].length;
    }
    catch (e) {
        r2 = 0;
    }
    c = Math.abs(r1 - r2);
    m = Math.pow(10, Math.max(r1, r2));
    if (c > 0) {
        var cm = Math.pow(10, c);
        if (r1 > r2) {
            arg1 = Number(arg1.toString().replace(".", ""));
            arg2 = Number(arg2.toString().replace(".", "")) * cm;
        } else {
            arg1 = Number(arg1.toString().replace(".", "")) * cm;
            arg2 = Number(arg2.toString().replace(".", ""));
        }
    } else {
        arg1 = Number(arg1.toString().replace(".", ""));
        arg2 = Number(arg2.toString().replace(".", ""));
    }
    return (arg1 + arg2) / m;
}
function isEmpty (arg) {
    return (arg == null || arg == '' || arg == 'undefined');
}
// 判断是否为空
function isNotEmpty (arg) {
    return (arg != null && arg != '' && arg != 'undefined' && arg != 'NaN-aN-aN');
}
function isNumber (arg) {
    var re = /^[0-9]+.?[0-9]*$/;
    return re.test(arg);
}
//是否为正整数
function isPositiveInteger(s){
    var re = /^[0-9]+$/ ;
    return re.test(s)
}
//任意正整数，正小数（小数位不超过2位）
function isPositiveIntegerAndFloat(s){
    var re=/^(([1-9][0-9]*)|(([0]\.\d{1,2}|[1-9][0-9]*\.\d{1,2})))$/;
    return re.test(s)
}
//任意正整数，正小数（小数位不超过2位）
function isPositiveIntegerAndFloat4(s){
    var re=/^(([1-9][0-9]*)|(([0]\.\d{1,4}|[1-9][0-9]*\.\d{1,4})))$/;
    return re.test(s)
}
//金额校验
function isPrice(s){
    var re = /^[0-9]+$/ ;
    return re.test(s)
}
//非空校验
function isNull(arg) {
    var result = "";
    if (isNotEmpty(arg)) {
    // if (null != arg) {
        result = arg;
    }
    return result;
}
//字数限制
function limit(arg) {
    var maxwidth=80;//设置最多显示的字数
    var result = "";
    if (isNotEmpty(arg)) {
        if(arg.length > maxwidth){
            result = arg.substring(0,maxwidth)+"...";
        } else {
            result = arg;
        }
    }
    return result;
}
//null转0
function nullToZero (arg) {
    if (isEmpty(arg)) {
        return 0;
    }
    return arg;
}
//"yyyy年MM月dd日"型时间校验
function checkDate(arg) {
    if (arg != null) {
        return NewDateYMD(arg).Format("yyyy年MM月dd日");
    } else {
        return "";
    }
}
//"yyyy年MM月dd日HH时mm分"型时间校验
function checkFullDate(arg) {
    if (arg != null) {
        return NewDateYMDHMS(arg).Format("yyyy年MM月dd日HH时mm分");
    } else {
        return "";
    }
}
function isDateNull(arg) {
    if (arg != null) {
        if (typeof arg == "string") {
            if (arg.split(' ').length > 1) {
                return NewDateYMDHMS(arg).Format("yyyy-MM-dd HH:mm:ss");
            } else {
                return NewDateYMD(arg).Format("yyyy-MM-dd");
            }
        } else {
            return new Date(arg).Format("yyyy-MM-dd HH:mm:ss");
        }
    } else {
        return "";
    }
}
function dateFormat(arg) {
    if (arg != null) {
        return new NewDateYMD(arg).Format("yyyy-MM-dd");
    } else {
        return "";
    }
}
//数字校验
function checkNumber(arg) {
    var result = 0;
    if (arg != null) {
        result = arg;
    }
    return result;
}
//打印div内容
function printDiv(printpage) {
    if (null == printpage) {
        window.print();
    } else {
        var printData = document.getElementById(printpage).innerHTML;
        var oldStr = document.body.innerHTML;
        document.body.innerHTML = printData;
        window.print();
        document.body.innerHTML = oldStr;
    }
    return false;
}

//将所有list集合中的null变成""
function isNullBeaomeEmpty(json){
    for(var i=0,l=json.length;i<l;i++){
        for(var key in json[i]){
            if(json[i][key]==null){
                json[i][key]="";
            }
        }
    }
    return json;
}

// 打印
function printArea(id){
    jQuery.print('#' + id);
}
