/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPrChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPrChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTrackChange;

public class SetRedUtil {
    private SetRedUtil() {
    }

    public static String setRed(String sourceWordUrl, String templateWordUrl, String outputUrl, String contentTag, Map<String, String> map) {
        String msg = "\u5957\u7ea2\u5931\u8d25";
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(sourceWordUrl));
            XWPFDocument mainDocument = new XWPFDocument((InputStream)fileInputStream);
            List paragraphs = mainDocument.getParagraphs();
            SetRedUtil.insertParagraphIntoTemplate(paragraphs, templateWordUrl, outputUrl, contentTag, map);
            msg = "\u5957\u7ea2\u6210\u529f";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return msg;
    }

    private static void insertParagraphIntoTemplate(List<XWPFParagraph> paraList, String templateUrl, String outputUrl, String contentTag, Map<String, String> nomarlParams) throws Exception {
        int startPoint = 0;
        FileInputStream redTemplateInputStream = new FileInputStream(new File(templateUrl));
        byte[] templateWord = new byte[redTemplateInputStream.available()];
        if (templateWord.length == 0) {
            return;
        }
        redTemplateInputStream.read(templateWord);
        XWPFDocument xwpfDocument = new XWPFDocument((InputStream)new ByteArrayInputStream(templateWord));
        SetRedUtil.changeText(xwpfDocument, nomarlParams);
        List paragraphs = xwpfDocument.getParagraphs();
        for (int i = 0; i < paragraphs.size(); ++i) {
            XWPFParagraph xwpfParagraph = (XWPFParagraph)paragraphs.get(i);
            List runs = xwpfParagraph.getRuns();
            for (int l = 0; l < runs.size(); ++l) {
                XWPFRun run = (XWPFRun)runs.get(l);
                if (!run.text().equals(contentTag)) continue;
                xwpfParagraph.removeRun(l);
                startPoint = i;
                break;
            }
            if (startPoint != 0) break;
        }
        if (startPoint != 0) {
            XWPFParagraph insertNewParagraph = (XWPFParagraph)paragraphs.get(startPoint);
            XmlCursor xmlCursor = insertNewParagraph.getCTP().newCursor();
            for (int j = 0; j < paraList.size(); ++j) {
                XWPFParagraph oldParagraph = paraList.get(j);
                CTPPr oldPPr = oldParagraph.getCTP().getPPr();
                if (oldPPr != null) {
                    CTParaRPr oldPPrRpr = oldPPr.getRPr();
                    CTPPrChange oldPPrChange = oldPPr.getPPrChange();
                    CTTrackChange rprIns = null;
                    CTParaRPrChange oldPraRprChange = null;
                    if (oldPPrRpr != null) {
                        rprIns = oldPPrRpr.getIns();
                        oldPraRprChange = oldPPrRpr.getRPrChange();
                    }
                    if (oldPPrChange != null) {
                        oldPPr.unsetPPrChange();
                    }
                    if (oldPraRprChange != null) {
                        oldPPrRpr.unsetRPrChange();
                    }
                    if (rprIns != null) {
                        oldPPrRpr.unsetIns();
                    }
                }
                insertNewParagraph.getCTP().setPPr(oldPPr);
                List runs = oldParagraph.getRuns();
                for (int k = 0; k < runs.size(); ++k) {
                    CTRPrChange oldRPrChange;
                    XWPFRun oldRun = (XWPFRun)runs.get(k);
                    CTRPr oldRPr = oldRun.getCTR().getRPr();
                    if (oldRPr != null && (oldRPrChange = oldRPr.getRPrChange()) != null) {
                        oldRPr.unsetRPrChange();
                    }
                    XWPFRun newRun = insertNewParagraph.createRun();
                    newRun.getCTR().setRPr(oldRPr);
                    newRun.setText(oldRun.text());
                    insertNewParagraph.addRun(newRun);
                }
                xmlCursor.toNextSibling();
                insertNewParagraph = xwpfDocument.insertNewParagraph(xmlCursor);
                xmlCursor = insertNewParagraph.getCTP().newCursor();
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(outputUrl);
        xwpfDocument.write((OutputStream)fileOutputStream);
    }

    public static void changeText(XWPFDocument document, Map<String, String> textMap) {
        List paragraphs = document.getParagraphs();
        for (XWPFParagraph paragraph : paragraphs) {
            String text = paragraph.getText();
            List runs = paragraph.getRuns();
            for (XWPFRun run : runs) {
                run.setText(SetRedUtil.changeValue(run.toString(), textMap), 0);
            }
        }
    }

    public static String changeValue(String value, Map<String, String> textMap) {
        Set<Map.Entry<String, String>> textSets = textMap.entrySet();
        for (Map.Entry<String, String> textSet : textSets) {
            String key = textSet.getKey();
            if (value.indexOf(key) == -1) continue;
            value = textSet.getValue();
        }
        return value;
    }
}

