/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.util;

import com.gtis.oa.model.Dispatch;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Component
public class MacroUtil {
    protected static final Logger logger = LoggerFactory.getLogger(MacroUtil.class);
    private static Configuration freeMarkerConfigurer;
    private static Map<String, HashMap<String, String>> templateView;

    private MacroUtil() {
    }

    @Autowired
    public void setFreeMarkerConfigurer(Configuration freeMarkerConfigurer) {
        MacroUtil.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    public static Template getTextTemplate(String templateName) throws IOException {
        return freeMarkerConfigurer.getTemplate("document/wordOcx/\u5957\u7ea2\u6a21\u677f/" + templateName + ".ftl");
    }

    public static Map<String, String> dispatchToMap(Dispatch dispatch, String basePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (dispatch.getDispatchId() != null) {
            map.put("dispatchId", dispatch.getDispatchId());
        } else {
            map.put("dispatchId", "");
        }
        if (dispatch.getDispatchTitle() != null) {
            map.put("dispatchTitle", dispatch.getDispatchTitle());
        } else {
            map.put("dispatchTitle", "");
        }
        if (dispatch.getCopySend() != null) {
            map.put("copySend", dispatch.getCopySend());
        }
        if (dispatch.getDispatchName() != null) {
            map.put("dispatchName", dispatch.getDispatchName());
        } else {
            map.put("dispatchName", "");
        }
        if (dispatch.getDispatchYear() != null) {
            map.put("dispatchYear", dispatch.getDispatchYear());
        } else {
            map.put("dispatchYear", "");
        }
        String dispatchNo = String.valueOf(dispatch.getDispatchNo());
        map.put("dispatchNo", dispatchNo);
        if (dispatch.getDispatchKeyword() != null) {
            map.put("dispatchKeyword", dispatch.getDispatchKeyword());
        } else {
            map.put("dispatchKeyword", "");
        }
        if (dispatch.getEmergency() != null) {
            map.put("emergency", dispatch.getEmergency());
        } else {
            map.put("emergency", "");
        }
        if (dispatch.getPrintNum() != null) {
            map.put("printNum", dispatch.getPrintNum());
        } else {
            map.put("printNum", "");
        }
        if (dispatch.getRemark() != null) {
            map.put("remark", dispatch.getRemark());
        } else {
            map.put("remark", "");
        }
        if (dispatch.getExigencyDegree() != null) {
            map.put("exigencyDegree", dispatch.getExigencyDegree());
        } else {
            map.put("exigencyDegree", "");
        }
        if (dispatch.getSerialNo() != null) {
            map.put("serialNo", dispatch.getSerialNo());
        } else {
            map.put("serialNo", "");
        }
        if (dispatch.getDocType() != null) {
            map.put("docType", dispatch.getDocType());
        } else {
            map.put("docType", "");
        }
        if (dispatch.getPublishType() != null) {
            map.put("publishType", dispatch.getPublishType());
        } else {
            map.put("publishType", "");
        }
        if (dispatch.getMainSend() != null) {
            map.put("mainSend", dispatch.getMainSend());
        } else {
            map.put("mainSend", "");
        }
        if (dispatch.getDraftDate() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            map.put("draftDate", sdf.format(new Date()));
        } else {
            map.put("draftDate", "");
            map.put("draftDate_zh", "");
        }
        map.put("url", basePath);
        return map;
    }

    public static String parseTemplet(Dispatch zsDispatch, String basePath) throws Exception {
        Template docType = null;
        docType = StringUtils.isNotBlank((String)zsDispatch.getDispatchName()) ? MacroUtil.getTextTemplate(zsDispatch.getDispatchName()) : MacroUtil.getTextTemplate("\u7a7a\u767d\u6a21\u677f");
        String data = "";
        try {
            data = FreeMarkerTemplateUtils.processTemplateIntoString((Template)docType, MacroUtil.dispatchToMap(zsDispatch, basePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }
}

