/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller.rest;

import com.alibaba.fastjson.JSON;
import com.gtis.oa.model.News;
import com.gtis.oa.model.PageDataModel;
import com.gtis.oa.model.Schedule;
import com.gtis.oa.service.NewsService;
import com.gtis.oa.service.ScheduleService;
import com.gtis.oa.util.CalendarUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/rest/news"})
public class NewsRestController {
    private static final Logger log = LoggerFactory.getLogger(NewsRestController.class);
    @Autowired
    NewsService newsService;
    @Autowired
    ScheduleService scheduleService;
    private DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Value(value="${app.storage}")
    private String storage;

    @RequestMapping(value={"/getListByType"})
    @ResponseBody
    public String getListByType(HttpServletRequest request, int newType) {
        ArrayList<PageDataModel> list = new ArrayList<PageDataModel>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("newType", Integer.toHexString(newType));
        List<News> newsList = this.newsService.getListByType(map);
        for (News aNewsList : newsList) {
            PageDataModel pageDataModel = new PageDataModel();
            pageDataModel.setId(aNewsList.getId());
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            if (newType == 3 || newType == 4) {
                pageDataModel.setTitle(aNewsList.getFileName());
                pageDataModel.setUrl(this.storage + "/rest/files/download/" + aNewsList.getFileId());
            } else {
                pageDataModel.setTitle(aNewsList.getNewTitle());
                pageDataModel.setUrl(basePath + "/oa/news/show?id=" + aNewsList.getId());
            }
            Date time = aNewsList.getNewUpdateDate();
            pageDataModel.setTime(this.sdf.format(time));
            list.add(pageDataModel);
        }
        HashMap<String, ArrayList<PageDataModel>> dataMap = new HashMap<String, ArrayList<PageDataModel>>();
        dataMap.put("list", list);
        return JSON.toJSONString(dataMap);
    }

    @RequestMapping(value={"/getScheduleList"})
    @ResponseBody
    public String getScheduleList(HttpServletRequest request, String beginTime, String endTime, String colorTyp, String participantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        beginTime = CalendarUtil.formateDatetoStr(CalendarUtil.formatDate(beginTime));
        endTime = CalendarUtil.formateDatetoStr(CalendarUtil.formatDate(endTime));
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        map.put("participantId", participantId);
        List<Schedule> scheduleList = null;
        try {
            scheduleList = this.scheduleService.getIndexList(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, List<Schedule>> resultMap = new HashMap<String, List<Schedule>>();
        resultMap.put("scheduleList", scheduleList);
        return JSON.toJSONString(resultMap);
    }
}

