/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.Telephone;
import com.gtis.oa.model.page.TelephonePage;
import com.gtis.oa.service.TelephoneService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/telephone"})
public class TelephoneController {
    @Autowired
    TelephoneService telephoneService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId, String view) {
        Telephone telephone = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            telephone = (Telephone)((Object)this.telephoneService.getById((Serializable)((Object)processInsId)));
        }
        if (telephone == null) {
            telephone = new Telephone();
            telephone.setId(processInsId);
        }
        model.addAttribute("telephone", (Object)telephone);
        model.addAttribute("view", (Object)view);
        return "officeapply/telephone/telephone_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/telephone/telephone_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(TelephonePage telephonePage, long page, long limit) {
        telephonePage.setCurrent(page);
        telephonePage.setSize(limit);
        IPage<Telephone> telephoneIPage = this.telephoneService.findByPage(telephonePage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", telephoneIPage.getRecords());
        resultMap.put("count", telephoneIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Telephone> save(Telephone telephone) {
        return new ResponseMessage<Telephone>((Boolean)this.telephoneService.saveOrUpdate((Object)telephone), telephone);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Telephone> delete(String[] ids) {
        return new ResponseMessage<Telephone>(this.telephoneService.removeByIds(Arrays.asList(ids)));
    }
}

