/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Receive;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.ReceivePage;
import com.gtis.oa.service.ReceiveService;
import com.gtis.oa.util.CommonUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/receive"})
public class ReceiveController {
    @Autowired
    ReceiveService receiveService;
    @Autowired
    StorageClient storageClient;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId, String view) {
        String userName = CommonUtil.getUser().getUsername();
        Receive receive = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            receive = (Receive)((Object)this.receiveService.getById((Serializable)((Object)processInsId)));
        }
        if (receive == null) {
            receive = new Receive();
            receive.setReceiveId(processInsId);
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            receive.setReceiveYear(year + "");
            receive.setReceiveDate(new Date());
            receive.setReplyDate(new Date());
        }
        model.addAttribute("receive", (Object)receive);
        model.addAttribute("view", (Object)view);
        model.addAttribute("userName", (Object)userName);
        return "document/receive/receive_edit";
    }

    @RequestMapping(value={"/list"})
    public String list() {
        return "document/receive/receive_list";
    }

    @RequestMapping(value={"/viewList"})
    public String viewList() {
        return "document/receive/receive_list_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(ReceivePage receivePage, long page, long limit) {
        receivePage.setCurrent(page);
        receivePage.setSize(limit);
        IPage<Receive> receiveIPage = this.receiveService.findByPage(receivePage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", receiveIPage.getRecords());
        resultMap.put("count", receiveIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/findTempByPage"})
    @ResponseBody
    public IPage<Receive> findTempByPage(ReceivePage receivePage) {
        IPage<Receive> receiveIPage = this.receiveService.findByPage(receivePage);
        return receiveIPage;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Receive> save(Receive receive) {
        return new ResponseMessage<Receive>((Boolean)this.receiveService.saveOrUpdate((Object)receive), receive);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Receive> delete(String[] ids) {
        return new ResponseMessage<Receive>(this.receiveService.removeByIds(Arrays.asList(ids)));
    }

    @RequestMapping(value={"/receiveNo"})
    @ResponseBody
    public long receiveNo(String name, String year) {
        long no = 0L;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("receiveName", name);
        map.put("receiveYear", year);
        Object queryNo = this.receiveService.getMaxReceiveNo(map);
        if (queryNo != null) {
            no = (Long)queryNo;
        }
        return no + 1L;
    }

    @RequestMapping(value={"onlyoffice"})
    public String onlyoffice(Model model, String processInsId, HttpServletRequest request) throws Exception {
        String clientId = "officeAut";
        List file = null;
        ArrayList files = new ArrayList();
        List folders = this.storageClient.listAllRootStorages(clientId, processInsId, null, null, null, Integer.valueOf(0));
        if (folders != null && !folders.isEmpty()) {
            for (StorageDto folder : folders) {
                if (!folder.getName().equals("\u6536\u6587\u6b63\u6587") || (file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1))).size() <= 0) continue;
                files.add(file.get(0));
            }
        }
        if (CollectionUtils.isNotEmpty(files)) {
            model.addAttribute("url", (Object)((StorageDto)files.get(0)).getDownUrl());
            String fileName = ((StorageDto)files.get(0)).getName();
            String name = fileName.substring(0, fileName.lastIndexOf("."));
            String type = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            model.addAttribute("name", (Object)name);
            model.addAttribute("type", (Object)type);
        } else {
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
            model.addAttribute("url", (Object)("" + basePath + "static/blank.docx"));
            String fileName = "blank.doc";
            model.addAttribute("name", (Object)"blank");
            model.addAttribute("type", (Object)"docx");
        }
        return "document/receive/only_office";
    }
}

