/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.News;
import com.gtis.oa.model.PageDataModel;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.NewsPage;
import com.gtis.oa.service.NewsService;
import com.gtis.oa.util.CommonUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/news"})
public class NewsController {
    private static final Logger log = LoggerFactory.getLogger(NewsController.class);
    @Autowired
    StorageClient storageClient;
    @Autowired
    NewsService newsService;
    @Value(value="${app.storage}")
    private String storage;

    @RequestMapping(value={"/index"})
    public String index(String id, Model model, int newType, String view) {
        News news = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", id);
            map.put("newType", newType);
            news = this.newsService.findByMap(map);
        }
        if (news == null) {
            news = new News();
            news.setId(id);
            news.setNewDate(new Date());
            news.setNewType(newType);
            news.setNewPublisher(CommonUtil.getUsername());
            news.setNewPublisherId(CommonUtil.getUserId());
        }
        model.addAttribute("news", (Object)news);
        model.addAttribute("view", (Object)view);
        if (newType == 0) {
            return "management/news/news_edit";
        }
        if (newType == 1) {
            return "management/news/notice_edit";
        }
        if (newType == 2) {
            return "management/news/share_edit";
        }
        return null;
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, int newType, String type) {
        model.addAttribute("newType", (Object)newType);
        model.addAttribute("type", (Object)type);
        if (newType == 0) {
            if ("view".equals(type)) {
                return "management/news/news_list_view";
            }
            return "management/news/news_list";
        }
        if (newType == 1) {
            if ("view".equals(type)) {
                return "management/news/notice_list_view";
            }
            return "management/news/notice_list";
        }
        if (newType == 2) {
            return "management/news/share_list";
        }
        if (newType == 3) {
            model.addAttribute("downUrl", (Object)(this.storage + "/rest/files/download/"));
            return "management/news/rule_list";
        }
        if (newType == 4) {
            model.addAttribute("downUrl", (Object)(this.storage + "/rest/files/download/"));
            return "management/news/publicFile_list";
        }
        return null;
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(NewsPage newsPage, long page, long limit) {
        newsPage.setCurrent(page);
        newsPage.setSize(limit);
        IPage<News> newsIPage = this.newsService.findByPage(newsPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", newsIPage.getRecords());
        resultMap.put("count", newsIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/findViewByPage"})
    @ResponseBody
    public IPage<News> findViewByPage(NewsPage newsPage) {
        IPage<News> newsIPage = this.newsService.findByPage(newsPage);
        return newsIPage;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<News> save(News news) {
        ResponseMessage<News> a = null;
        News temp = new News();
        String newsId = news.getId();
        try {
            temp = (News)((Object)this.newsService.getById((Serializable)((Object)newsId)));
            a = temp == null ? new ResponseMessage<News>((Boolean)this.newsService.save((Object)news), news) : new ResponseMessage<News>((Boolean)this.newsService.updateById((Object)news), news);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return a;
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<News> delete(String[] ids) {
        return new ResponseMessage<News>(this.newsService.removeByIds(Arrays.asList(ids)));
    }

    @RequestMapping(value={"/getListByType"})
    @ResponseBody
    public String getListByType(HttpServletRequest request) {
        ArrayList<PageDataModel> list = new ArrayList<PageDataModel>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int newType = 0;
        map.put("newType", newType);
        List<News> newsList = this.newsService.getListByType(map);
        for (News aNewsList : newsList) {
            PageDataModel pageDataModel = new PageDataModel();
            pageDataModel.setId(aNewsList.getId());
            pageDataModel.setTitle(aNewsList.getNewTitle());
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
            pageDataModel.setUrl(basePath + "/oa/news/show?id=" + aNewsList.getId());
            list.add(pageDataModel);
        }
        HashMap<String, ArrayList<PageDataModel>> dataMap = new HashMap<String, ArrayList<PageDataModel>>();
        dataMap.put("list", list);
        return JSON.toJSONString(dataMap);
    }

    @RequestMapping(value={"/show"})
    public String show(Model model, String id) {
        News news = (News)((Object)this.newsService.getById((Serializable)((Object)id)));
        model.addAttribute("news", (Object)news);
        return "management/news/news_show";
    }

    @ResponseBody
    @RequestMapping(value={"/uploadFile"})
    public Map<String, Object> uploadFile(@RequestParam(value="file", required=false) MultipartFile multipartFile, int newType) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)6);
        if (multipartFile == null) {
            System.out.println("\u672a\u83b7\u5f97\u4e0a\u4f20\u6587\u4ef6!");
            return null;
        }
        try {
            String proid = UUID.hex32();
            MultipartDto multipartDto = new MultipartDto();
            multipartDto.setData(multipartFile.getBytes());
            multipartDto.setSpaceCode(proid);
            multipartDto.setClientId("officeAut");
            multipartDto.setName(multipartFile.getName());
            multipartDto.setSize(multipartFile.getSize());
            multipartDto.setContentType(multipartFile.getContentType());
            multipartDto.setOriginalFilename(multipartFile.getOriginalFilename());
            StorageDto storageDto = this.storageClient.multipartUpload(multipartDto);
            String fileName = multipartFile.getOriginalFilename();
            News news = new News();
            news.setId(proid);
            news.setNewType(newType);
            news.setNewPublisher(CommonUtil.getUsername());
            news.setNewPublisherId(CommonUtil.getUserId());
            news.setNewUpdateDate(new Date());
            news.setFileName(storageDto.getName());
            news.setFileId(storageDto.getId());
            this.newsService.save((Object)news);
            params.put("state", "SUCCESS");
            params.put("msg", "\u4e0a\u4f20\u6210\u529f");
            params.put("size", multipartFile.getSize());
            params.put("original", fileName);
            params.put("type", multipartFile.getContentType());
            params.put("filename", multipartFile.getOriginalFilename());
            System.out.println(JSON.toJSON((Object)params));
        }
        catch (Exception e) {
            params.put("state", "ERROR");
            log.error(e.getMessage());
        }
        return params;
    }

    @RequestMapping(value={"/deleteFile"})
    @ResponseBody
    public String deleteFile(String[] ids) {
        this.storageClient.deleteStorages(Arrays.asList(ids));
        return null;
    }
}

