/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Message;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.MessagePage;
import com.gtis.oa.service.MessageService;
import com.gtis.oa.util.CommonUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/message"})
public class MessageController {
    @Autowired
    private MessageService messageService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String proid, String accept) {
        Message message = null;
        if (StringUtils.isNotBlank((String)proid)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", proid);
            message = this.messageService.findByMap(map);
        }
        if (message == null) {
            message = new Message();
            message.setId(UUID.hex32());
            message.setIsPublished("\u672a\u53d1\u5e03");
            message.setMessagesendMan(CommonUtil.getUserId());
            message.setMessagesendManName(CommonUtil.getUser().getAlias());
        }
        model.addAttribute("message", (Object)message);
        if (StringUtils.isNotBlank((String)accept)) {
            model.addAttribute("accept", (Object)accept);
        }
        return "management/message/message_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(String type) {
        if ("manage".equals(type)) {
            return "management/message/message_list";
        }
        return "management/message/message_list_view";
    }

    @RequestMapping(value={"/acceptList"})
    public String acceptList(Model model, String type) {
        model.addAttribute("userName", (Object)CommonUtil.getUsername());
        if ("manage".equals(type)) {
            return "management/message/message_acceptList";
        }
        return "management/message/message_acceptList_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(MessagePage messagePage, long page, long limit) {
        messagePage.setCurrent(page);
        messagePage.setSize(limit);
        IPage<Message> messageIPage = this.messageService.findByPage(messagePage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", messageIPage.getRecords());
        resultMap.put("count", messageIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/findMyByPage"})
    @ResponseBody
    public Map<String, Object> findMyByPage(MessagePage messagePage, long page, long limit) {
        messagePage.setAcceptMans(CommonUtil.getUsername());
        messagePage.setCurrent(page);
        messagePage.setSize(limit);
        IPage<Message> messageIPage = this.messageService.findByPage(messagePage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", messageIPage.getRecords());
        resultMap.put("count", messageIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/findViewByPage"})
    @ResponseBody
    public IPage<Message> findViewByPage(MessagePage messagePage) {
        messagePage.setMessagesendManName(CommonUtil.getUsername());
        IPage<Message> messageIPage = this.messageService.findByPage(messagePage);
        return messageIPage;
    }

    @RequestMapping(value={"/findMyViewByPage"})
    @ResponseBody
    public IPage<Message> findMyViewByPage(MessagePage messagePage) {
        messagePage.setAcceptMans(CommonUtil.getUsername());
        IPage<Message> messageIPage = this.messageService.findByPage(messagePage);
        return messageIPage;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Message> save(Message message) {
        if (message.getCreateTime() != null) {
            return new ResponseMessage<Message>((Boolean)this.messageService.updateById((Object)message), message);
        }
        message.setCreateTime(new Date());
        return new ResponseMessage<Message>((Boolean)this.messageService.save((Object)message), message);
    }

    @RequestMapping(value={"/saveRead"})
    @ResponseBody
    public ResponseMessage<Message> saveRead(String id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        Message message = this.messageService.findByMap(map);
        message.setIsRead("1");
        return new ResponseMessage<Message>((Boolean)this.messageService.updateById((Object)message), message);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Message> delete(String[] ids) {
        return new ResponseMessage<Message>(this.messageService.removeByIds(Arrays.asList(ids)));
    }
}

