/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.MultipartDto;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import cn.gtmap.gtc.utilclient.common.client.rest.DictionaryClient;
import cn.gtmap.gtc.workflow.clients.manage.FlowableNodeClient;
import cn.gtmap.gtc.workflow.clients.manage.StatisticsTaskClient;
import cn.gtmap.gtc.workflow.clients.manage.TaskHandleClient;
import cn.gtmap.gtc.workflow.domain.manage.ForwardTaskDto;
import cn.gtmap.gtc.workflow.domain.manage.StatisticsTaskDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Dispatch;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.DispatchPage;
import com.gtis.oa.service.DispatchService;
import com.gtis.oa.util.CalendarUtil;
import com.gtis.oa.util.CommonUtil;
import com.gtis.oa.util.FileUtil;
import com.gtis.oa.util.MacroUtil;
import com.gtis.oa.util.SetRedUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/dispatch"})
public class DispatchController {
    @Autowired
    DispatchService dispatchService;
    @Autowired
    StorageClient storageClient;
    @Autowired
    UserManagerClient userManagerClient;
    @Autowired
    DictionaryClient dictionaryClient;
    @Autowired
    StatisticsTaskClient statisticsTaskClient;
    @Autowired
    FlowableNodeClient flowableNodeClient;
    @Autowired
    TaskHandleClient taskHandleClient;
    @Value(value="${fileStore.templateWordUrl}")
    private String templateWordUrl;
    @Value(value="${fileStore.sourceWordUrl}")
    private String sourceWordUrl;
    @Value(value="${fileStore.outputUrl}")
    private String outputUrl;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId, String view, String taskId) {
        try {
            String chuanyue = "";
            String activityName = "";
            String userName = CommonUtil.getUser().getUsername();
            Dispatch dispatch = null;
            if (StringUtils.isNotBlank((String)processInsId)) {
                dispatch = (Dispatch)((Object)this.dispatchService.getById((Serializable)((Object)processInsId)));
            }
            if (dispatch == null) {
                dispatch = new Dispatch();
                dispatch.setDispatchId(processInsId);
                Calendar calendar = Calendar.getInstance();
                int year = calendar.get(1);
                dispatch.setDispatchYear(year + "");
                dispatch.setDraftDate(new Date());
                dispatch.setIsRed(0);
            }
            String clientId = "officeAut";
            StorageDto storageDto = this.storageClient.createRootFolder(clientId, processInsId, "\u53d1\u6587\u6b63\u6587", null);
            List dispatchMainbodyList = this.dictionaryClient.findChildren("gtisoa", null, null, "dispatchMainbody", "\u53d1\u6587\u4e3b\u4f53", null, null, false);
            List docTypeList = this.dictionaryClient.findChildren("gtisoa", null, null, "docType", "\u884c\u6587\u7c7b\u522b", null, null, false);
            model.addAttribute("dispatchMainbodyList", (Object)dispatchMainbodyList);
            model.addAttribute("docTypeList", (Object)docTypeList);
            model.addAttribute("dispatch", (Object)dispatch);
            model.addAttribute("view", (Object)view);
            model.addAttribute("userName", (Object)userName);
            String isFile = "false";
            List<StorageDto> files = this.isFile(processInsId);
            if (CollectionUtils.isNotEmpty(files)) {
                isFile = "true";
            }
            Integer isChuanyue = dispatch.getIsChuanyue();
            if (StringUtils.isNotBlank((String)taskId)) {
                StatisticsTaskDto statisticsTaskDto = this.statisticsTaskClient.getById(taskId);
                activityName = statisticsTaskDto.getTaskName();
                if ("\u6838\u7a3f".equals(activityName) && isChuanyue == 0) {
                    chuanyue = "true";
                } else if ("\u6838\u7a3f".equals(activityName) && isChuanyue == 1) {
                    chuanyue = "false";
                }
            }
            model.addAttribute("isFile", (Object)isFile);
            String isRed = "false";
            if (dispatch.getIsRed() == 1) {
                isRed = "true";
            }
            model.addAttribute("isRed", (Object)isRed);
            model.addAttribute("chuanyue", (Object)chuanyue);
            model.addAttribute("taskId", (Object)taskId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "document/dispatch/dispatch_edit";
    }

    @RequestMapping(value={"/list"})
    public String list() {
        return "document/dispatch/dispatch_list";
    }

    @RequestMapping(value={"/viewList"})
    public String viewList() {
        return "document/dispatch/dispatch_list_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(DispatchPage dispatchPage, long page, long limit) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            dispatchPage.setCurrent(page);
            dispatchPage.setSize(limit);
            IPage<Dispatch> dispatchIPage = this.dispatchService.findByPage(dispatchPage);
            resultMap.put("code", "0");
            resultMap.put("data", dispatchIPage.getRecords());
            resultMap.put("count", dispatchIPage.getTotal());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    @RequestMapping(value={"/findTempByPage"})
    @ResponseBody
    public IPage<Dispatch> findTempByPage(DispatchPage dispatchPage) {
        IPage<Dispatch> dispatchIPage = this.dispatchService.findByPage(dispatchPage);
        return dispatchIPage;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Dispatch> save(Dispatch dispatch) {
        dispatch.setSerialNo(dispatch.getDispatchName() + "\u3014" + dispatch.getDispatchYear() + "\u3015" + dispatch.getDispatchNo() + "\u53f7");
        return new ResponseMessage<Dispatch>((Boolean)this.dispatchService.saveOrUpdate((Object)dispatch), dispatch);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Dispatch> delete(String[] ids) {
        return new ResponseMessage<Dispatch>(this.dispatchService.removeByIds(Arrays.asList(ids)));
    }

    @RequestMapping(value={"/dispatchNo"})
    @ResponseBody
    public long dispatchNo(String name, String year) {
        long no = 0L;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dispatchName", name);
        map.put("dispatchYear", year);
        Object queryNo = this.dispatchService.getMaxDispatchNo(map);
        if (queryNo != null) {
            no = (Long)queryNo;
        }
        return no + 1L;
    }

    @RequestMapping(value={"/content"})
    public String content(Model model, String processInsId, HttpServletRequest request) throws Exception {
        String unitName = "";
        String clientId = "officeAut";
        List file = null;
        ArrayList files = new ArrayList();
        List folders = this.storageClient.listAllRootStorages(clientId, processInsId, null, null, null, Integer.valueOf(0));
        if (folders != null && !folders.isEmpty()) {
            for (StorageDto folder : folders) {
                if (!folder.getName().equals("\u53d1\u6587\u6b63\u6587")) continue;
                file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1));
                files.add(file.get(0));
            }
        }
        String docfileName = "";
        String docfid = "";
        String cebfid = "";
        String cebfileName = null;
        if (files != null) {
            for (StorageDto f : files) {
                if (f.getName().toLowerCase().endsWith(".doc") || f.getName().toLowerCase().endsWith(".docx")) {
                    docfid = f.getId();
                    docfileName = f.getName();
                }
                if (!f.getName().toLowerCase().endsWith(".ceb")) continue;
                cebfid = f.getId();
                cebfileName = f.getName();
            }
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
        model.addAttribute("basePath", (Object)basePath);
        model.addAttribute("unitName", (Object)unitName);
        model.addAttribute("docfileName", (Object)docfileName);
        model.addAttribute("docfid", (Object)docfid);
        model.addAttribute("cebfid", (Object)cebfid);
        model.addAttribute("cebfileName", (Object)cebfileName);
        Dispatch dispatch = (Dispatch)((Object)this.dispatchService.getById((Serializable)((Object)processInsId)));
        if (dispatch == null) {
            dispatch = new Dispatch();
        }
        model.addAttribute("dispatch", (Object)dispatch);
        model.addAttribute("macroStr", (Object)MacroUtil.parseTemplet(dispatch, basePath));
        String redhead = "";
        model.addAttribute("redhead", (Object)redhead);
        UserDto userDto = this.userManagerClient.getCurrentUser();
        String userName = userDto.getUsername();
        List userDptList = userDto.getOrgRecordList();
        String userDpt = ((OrganizationDto)userDptList.get(0)).getName();
        model.addAttribute("loginuser", (Object)userName);
        model.addAttribute("userDpt", (Object)userDpt);
        model.addAttribute("proid", (Object)processInsId);
        model.addAttribute("author", (Object)this.checkPlatformAuthor(processInsId));
        return "document/dispatch/dispatch_content";
    }

    public Map checkPlatformAuthor(String proid) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        paraMap.put("proid", proid);
        paraMap.put("saveCtrl", "TRUE");
        paraMap.put("canExecMacro", "TRUE");
        paraMap.put("canImport", "FALSE");
        paraMap.put("canTransCEB", "FALSE");
        paraMap.put("IsRecMark", "FALSE");
        paraMap.put("canSaveas", "FALSE");
        return paraMap;
    }

    @RequestMapping(value={"onlyoffice"})
    public String onlyoffice(Model model, String processInsId, HttpServletRequest request) throws Exception {
        List<StorageDto> files = this.isFile(processInsId);
        if (CollectionUtils.isNotEmpty(files)) {
            model.addAttribute("url", (Object)files.get(0).getDownUrl());
            String fileName = files.get(0).getName();
            String name = fileName.substring(0, fileName.lastIndexOf("."));
            String type = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            model.addAttribute("name", (Object)name);
            model.addAttribute("type", (Object)type);
            model.addAttribute("mode", (Object)"view");
        } else {
            String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/";
            model.addAttribute("url", (Object)("" + basePath + "static/blank.docx"));
            String fileName = "blank.doc";
            model.addAttribute("name", (Object)"blank");
            model.addAttribute("type", (Object)"docx");
        }
        return "document/dispatch/only_office";
    }

    public List<StorageDto> isFile(String processInsId) {
        String clientId = "officeAut";
        List file = null;
        ArrayList<StorageDto> files = new ArrayList<StorageDto>();
        List folders = this.storageClient.listAllRootStorages(clientId, processInsId, null, null, null, Integer.valueOf(0));
        if (folders != null && !folders.isEmpty()) {
            for (StorageDto folder : folders) {
                if (!folder.getName().equals("\u53d1\u6587\u6b63\u6587") || (file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1))).size() <= 0) continue;
                files.add((StorageDto)file.get(0));
            }
        }
        return files;
    }

    @RequestMapping(value={"wordRed"})
    @ResponseBody
    public String wordRed(String processInsId, HttpServletRequest request) {
        String msg = "\u5957\u7ea2\u5931\u8d25";
        Dispatch dispatch = (Dispatch)((Object)this.dispatchService.getById((Serializable)((Object)processInsId)));
        if (dispatch.getIsRed() == 0) {
            List<StorageDto> files = this.isFile(processInsId);
            String nodeId = "";
            List folders = this.storageClient.listAllRootStorages("officeAut", processInsId, null, null, null, Integer.valueOf(0));
            if (folders != null && !folders.isEmpty()) {
                for (StorageDto folder : folders) {
                    if (!folder.getName().equals("\u53d1\u6587\u6b63\u6587")) continue;
                    nodeId = folder.getId();
                }
            }
            if (CollectionUtils.isNotEmpty(files)) {
                try {
                    FileUtil.downLoadFromUrl(files.get(0).getDownUrl(), files.get(0).getName(), this.sourceWordUrl);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String wordUrl = this.sourceWordUrl + files.get(0).getName();
                String templateUrl = this.templateWordUrl + dispatch.getDispatchName() + ".docx";
                String outWordUrl = this.outputUrl + files.get(0).getName();
                String contentTag = "param";
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("bh", dispatch.getDispatchName());
                map.put("year", dispatch.getDispatchYear());
                map.put("no", dispatch.getDispatchNo().toString());
                map.put("title", dispatch.getDispatchTitle());
                String draftDate = CalendarUtil.SDF_CHINA.format(dispatch.getDraftDate());
                map.put("draftDate", draftDate);
                map.put("unitName", "\u8fde\u4e91\u6e2f\u81ea\u7136\u8d44\u6e90\u548c\u89c4\u5212\u5c40");
                msg = SetRedUtil.setRed(wordUrl, templateUrl, outWordUrl, contentTag, map);
                if (msg.equals("\u5957\u7ea2\u6210\u529f")) {
                    MultipartFile multipartFile = null;
                    try {
                        multipartFile = FileUtil.fileToMultipartFile(outWordUrl);
                        ArrayList<String> ids = new ArrayList<String>();
                        ids.add(files.get(0).getId());
                        this.storageClient.deleteStorages(ids);
                        MultipartDto multipartDto = new MultipartDto();
                        multipartDto.setData(multipartFile.getBytes());
                        multipartDto.setSpaceCode(processInsId);
                        multipartDto.setNodeId(nodeId);
                        multipartDto.setClientId("officeAut");
                        multipartDto.setName(multipartFile.getName());
                        multipartDto.setSize(multipartFile.getSize());
                        multipartDto.setContentType(multipartFile.getContentType());
                        multipartDto.setOriginalFilename(multipartFile.getOriginalFilename());
                        this.storageClient.multipartUpload(multipartDto);
                        File file = new File(outWordUrl);
                        if (file.exists()) {
                            file.delete();
                        }
                        dispatch.setIsRed(1);
                        this.dispatchService.saveOrUpdate((Object)dispatch);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return msg;
    }

    @RequestMapping(value={"delWordRed"})
    @ResponseBody
    public String delWordRed(String processInsId, HttpServletRequest request) {
        String msg = "\u53d6\u6d88\u5957\u7ea2";
        List<StorageDto> files = this.isFile(processInsId);
        String nodeId = "";
        List folders = this.storageClient.listAllRootStorages("officeAut", processInsId, null, null, null, Integer.valueOf(0));
        if (folders != null && !folders.isEmpty()) {
            for (StorageDto folder : folders) {
                if (!folder.getName().equals("\u53d1\u6587\u6b63\u6587")) continue;
                nodeId = folder.getId();
            }
        }
        try {
            MultipartFile multipartFile = null;
            String wordUrl = this.sourceWordUrl + files.get(0).getName();
            multipartFile = FileUtil.fileToMultipartFile(wordUrl);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(files.get(0).getId());
            this.storageClient.deleteStorages(ids);
            MultipartDto multipartDto = new MultipartDto();
            multipartDto.setData(multipartFile.getBytes());
            multipartDto.setSpaceCode(processInsId);
            multipartDto.setNodeId(nodeId);
            multipartDto.setClientId("officeAut");
            multipartDto.setName(multipartFile.getName());
            multipartDto.setSize(multipartFile.getSize());
            multipartDto.setContentType(multipartFile.getContentType());
            multipartDto.setOriginalFilename(multipartFile.getOriginalFilename());
            this.storageClient.multipartUpload(multipartDto);
            Dispatch dispatch = (Dispatch)((Object)this.dispatchService.getById((Serializable)((Object)processInsId)));
            dispatch.setIsRed(0);
            this.dispatchService.saveOrUpdate((Object)dispatch);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return msg;
    }

    @RequestMapping(value={"/chuanyue"})
    @ResponseBody
    public void chuanyue(String processDefKey, String userNames, String taskId) {
        try {
            List<String> usernameList = Arrays.asList(userNames.split(","));
            List forwardTaskDtoList = this.flowableNodeClient.getForwardUserTasks(taskId, null);
            for (ForwardTaskDto forwardTaskDto : forwardTaskDtoList) {
                String activityId = forwardTaskDto.getActivityId();
                String activityName = forwardTaskDto.getActivityName();
                if (!"\u4f20\u9605".equals(activityName)) continue;
                this.taskHandleClient.addReadTask(taskId, activityId, usernameList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

