<@com.html title="日程安排" import="layui,calendar,main,util,xadmin"/>
<body class="gtmap blueStyle">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
    .gtmap .layui-table td,.gtmap .layui-table th{
        line-height:0px!important;
    }
    #layerEdit{
        position: absolute;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        overflow: auto;
        background-color: #fff;
    }
    .gtmap .gt-toolbar{
        top: auto;
        bottom: 10px;
        border-bottom: 0px;
        text-align: center;
        background-color: #fff;
    }
</style>
<div id="layerEdit">
    <form class="layui-form" id="scheduleForm">
        <input type="hidden" name="id" value="${schedule.id!}" id="id" >
        <input type="hidden" id="acceptView" name="acceptView" value="${acceptView!}" >
        <input type="hidden" id="appointerId" name="appointerId" value="${schedule.appointerId!}" >
        <input type="hidden" id="isPublished" name="isPublished" value="${schedule.isPublished!}" >
        <input type="hidden" id="appointerName" name="appointerName" value="${schedule.appointerName!}" >
        <input type="hidden" id="createTime" name="createTime" value="${(schedule.createTime!.now)?string('yyyy-MM-dd HH:mm:ss')}" >
        <#if acceptView != "">
        <#else>
            <@toolbar show="save,del" />
        </#if>
        <div style="margin: 0 auto;background: #fff;padding: 0 30px;">
            <#--<h3 class="text-c">日程安排</h3>-->
            <h5 class="text-r">&nbsp;</h5>
            <table class="layui-table table-border">
                <tr>
                    <td class="text-c active" style="width: 10%;">标题</td>
                    <td class="pd0" colspan="7">
                        <input class="layui-input" type="text" id="caption" name="caption"  value="${schedule.caption!}" lay-verify="required">
                    </td>
                </tr>
                <tr>
                    <td class="text-c active" >日程类型</td>
                    <td class="pd0" colspan="3">
                        <select id="scheduleType" name="scheduleType">
                            <option value="个人日程"<#if schedule.scheduleType?? && schedule.scheduleType=='个人日程'>selected </#if>>个人日程</option>
                            <option value="多人日程"<#if schedule.scheduleType?? && schedule.scheduleType=='多人日程'>selected </#if>>多人日程</option>
                        </select>
                    </td>
                    <td class="text-c active" >是否公开</td>
                    <td class="pd0" colspan="3">
                        <select id="isPublic" name="isPublic">
                            <option value="否"<#if schedule.isPublic?? && schedule.isPublic=='否'>selected </#if>>否</option>
                            <option value="是"<#if schedule.isPublic?? && schedule.isPublic=='是'>selected </#if>>是</option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <td class="text-c active" style="width: 10%;">开始时间</td>
                    <td class="pd0" colspan="3">
                        <input class="layui-input layui-date"  type="text" id="beginTime" name="beginTime" placeholder="开始时间" value="${(schedule.beginTime!.now)?string('yyyy-MM-dd HH:mm:ss')}">
                    </td>
                    <td class="text-c active" style="width: 10%;">结束时间</td>
                    <td class="pd0" colspan="3">
                        <input class="layui-input layui-date"  type="text" id="endTime" name="endTime" placeholder="结束时间" value="${(schedule.endTime!.now)?string('yyyy-MM-dd HH:mm:ss')}">
                    </td>
                </tr>
                <tr>
                    <td class="text-c active" style="width: 10%;">参与者</td>
                    <td class="pd0" colspan="7">
                        <input class="layui-input" type="text" id="participantId" name="participantId" lay-verify="required" value="${schedule.participantId!}">
                    </td>
                </tr>
                <tr>
                    <td class="text-c active" style="height: 68px">日程内容</td>
                    <td colspan="7" class="pd0">
                        <textarea class="layui-textarea" id='content' name='content' lay-verify="content">${schedule.content!}</textarea>
                    </td>
                </tr>
            </table>
        </div>
    </form>
</div>
<script type="text/javascript">
    layui.use(['form','laydate'], function(){
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;

        //获取点击后url传入的日期
        window.getQueryString=function(name) {
            var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
            var r = window.location.search.substr(1).match(reg);
            if (r != null) {
                return unescape(r[2]);
            }
            return null;
        };
        var defaultBeginDate =getQueryString("defaultBeginDate");
        var defaultEndDate =getQueryString("defaultEndDate");

        laydate.render({
            elem: '#createTime', //指定元素
            type:'datetime',
            trigger: 'click'
            //range: true
        });
        laydate.render({
            elem: '#beginTime', //指定元素
            type:'datetime',
            trigger: 'click'
//            ,format: 'yyyy-MM-dd HH:mm'
            ,value: defaultBeginDate
        });
        laydate.render({
            elem: '#endTime', //指定元素
            type:'datetime',
            trigger: 'click'
//            ,format: 'yyyy-MM-dd HH:mm'
            ,value: defaultEndDate
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });

        //点击事件（删除）
        $("#del").click(function (e) {
            deleteSchedule();
        });

        /**
         * 表单提交
         */
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/schedule/save",
                dataType: "json",
                data: $("#scheduleForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#id").val(data.empty.id);
                            var index=parent.layer.getFrameIndex(window.name);
                            layer.close(layer.index);
                            window.parent.location.reload();
                        });
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }

                }
            });

        }

        window.deleteSchedule = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                ids.push($("#id").val());

                $.ajax({
                    type : "post",
                    url : "${base}/schedule/delete",
                    traditional: true,
                    data : {"ids" :ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2000
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.msg(data.message, {icon: 1, time: 1000});
                            layer.close(layer.index);
                            window.parent.location.reload();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //监听提交
        $(document).on('click','#participantId',function(){
            var linkId = $("#id").val();
            var peopleId = "participantId";//此处配置业务表单人员的字段
            x_admin_show('<i class="icon-user" style="fon-:"></i>'+" 人员选择","${base}/promulgator/index?linkId="+linkId+"&peopleId="+peopleId,"400","350");
        });
    });
    $(function () {
        var div = document.getElementById("layerEdit");
        var layerEdit = $("#layerEditdiv").find("div").length;
        if (layerEdit=="0"){
            var top = window.getComputedStyle(div,null).top;
            div.style.setProperty("top", "0px");
        }
    });
</script>
</body>


