<@com.html title="政策法规" import="layui,jquery,ztree,font"/>
<style>
    html, body {
        margin: 0;
        padding: 0px;
        height: 100%;
        background-color: rgb(233, 238, 243);
        box-sizing: border-box;
    }
    .main-box {
        background-color: #fff;
        height: 100%;
        box-sizing: border-box;
        /*padding: 10px;*/
    }

    .left-box {
        background-color: #fff;
        width: 300px;
        float: left;
        height: 100%;
        border-right: 1px solid #ccc;
        box-sizing: border-box;
    }

    .right-box {
        margin-left: 300px;
        height: 100%;
        background-color: #fff;
        position: relative;
    }
    .ztree * {
        font-size: 14px!important;
    }
    .content_wrap {
        height: calc(100%);
    }
</style>
<input type="hidden" name="type" id="type" value="${type!}"/>
<div class="main-box">
    <div class="left-box">
        <div class="content_wrap">
            <ul id="lawsType" class="ztree" style="width:96%;height: 98%; overflow-y:auto;"></ul>
        </div>
    </div>
    <div class="right-box">
        <div id="hhh">

        </div>
    </div>
</div>
<script>
    layui.use(['jquery', 'form'], function () {
        var form = layui.form;
        initZTree();
        var type = $("[name='type']").val();
        if(type == "view"){
            var allUrl = '${base}/laws/list?treeLinkId='+'&treeName='+'&type=view';
        } else if(type == "manage"){
            var allUrl = '${base}/laws/list?treeLinkId='+'&treeName='+'&type=manage';
        }
        var allContent = "<iframe src='"+allUrl+"'frameborder=\"0\" style=\"width: 100%;height:100%; position: absolute; \" ></iframe>";
        $("#hhh").html(allContent);
    });

    //树设置
    var setting = {
        view: {
            dblClickExpand: false
        },
        data: {
            simpleData: {
                enable: true,
                idKey: "typeId",   //节点数据中保存唯一标识的属性名称
                pIdKey: "ftypeParentId",    //节点数据中保存其父节点唯一标识的属性名称
                rootPId: -1  //用于修正根节点父节点数据，即 pIdKey 指定的属性值
            },
            key: {
                name: "fname"  //zTree 节点数据保存节点名称的属性名称  默认值："name"
            }
        },
        callback: {
            onClick: zTreeOnClick
        }
    };

    //初始化树
    var treeObj, rMenu,ztreeNode;
    var rMenu;
    function initZTree() {
        $.ajax({
            type:"GET",
            url:"/oa/lawsType/getLawsTypeList",
            dataType:"json",
            async:true,
            success:function(lawsTypeList){
                $.fn.zTree.init($("#lawsType"), setting, lawsTypeList); //初始化树
                rMenu=$("#rMenu");
                treeObj = $.fn.zTree.getZTreeObj("lawsType");
                var nodes = treeObj.getNodes();
                treeObj.hideNode(treeObj.getNodeByParam("isUse","否"));
                treeObj.expandAll(true);   //true 节点全部展开、false节点收缩
            }
        });
    }
    /**
     * 单击赋值属性值
     * @param event
     * @param treeId
     * @param treeNode
     */
    function zTreeOnClick(event, treeId, treeNode) {
        treeObj = $.fn.zTree.getZTreeObj("lawsType");
        if(treeNode.isParent){
            if(treeNode.open) {
                treeObj.expandNode(treeNode, false, null, null);
            }else{
                treeObj.expandNode(treeNode, true, null, null);
            }
            return false;
        }

        var treeLinkId = getCurrentRoot(treeNode);

        var type = $("[name='type']").val();
        var allUrl = '${base}/laws/list?treeLinkId='+treeLinkId+'&treeName='+treeNode.fname+"&type="+type;
        var allContent = "<iframe src='"+allUrl+"'frameborder=\"0\" style=\"width: 100%;height:100%; position: absolute; \" ></iframe>";
        $("#hhh").html(allContent);
    }

    //获取当前节点的根节点(treeNode为当前节点)
    function getCurrentRoot(treeNode){
        if(treeNode.getParentNode()!=null){
            var parentNode = treeNode.getParentNode();
            return getCurrentRoot(parentNode);
        }else{
            return treeNode.typeId;
        }
    }
</script>
