/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.mapper.AssetAttachmentMapper;
import com.gtis.oa.model.Asset;
import com.gtis.oa.model.AssetAttachment;
import com.gtis.oa.model.AssetModel;
import com.gtis.oa.model.page.AssetAttachmentPage;
import com.gtis.oa.service.AssetAttachmentService;
import com.gtis.oa.service.AssetService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AssetAttachmentServiceImpl
extends ServiceImpl<AssetAttachmentMapper, AssetAttachment>
implements AssetAttachmentService {
    @Autowired
    AssetAttachmentMapper assetAttachmentMapper;
    @Autowired
    AssetService assetService;
    @Autowired
    AssetAttachmentService assetAttachmentService;

    @Override
    public List<AssetAttachment> findByMap(HashMap map) {
        return this.assetAttachmentMapper.findByMap(map);
    }

    @Override
    public IPage<AssetAttachment> findByPage(AssetAttachmentPage assetAttachmentPage) {
        return this.assetAttachmentMapper.findByPage(assetAttachmentPage);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAsset(AssetModel assetModel) {
        Asset asset = null;
        if (assetModel != null) {
            asset = (Asset)((Object)this.assetService.getById((Serializable)((Object)assetModel.getId())));
            if (asset != null) {
                asset.setApplyUnit(assetModel.getApplyUnit());
                asset.setApplyPeople(assetModel.getApplyPeople());
                asset.setApplyTime(assetModel.getApplyTime());
                asset.setReason(assetModel.getReason());
                this.assetService.updateById((Object)asset);
            } else {
                asset = new Asset();
                asset.setId(assetModel.getId());
                asset.setApplyUnit(assetModel.getApplyUnit());
                asset.setApplyPeople(assetModel.getApplyPeople());
                asset.setApplyTime(assetModel.getApplyTime());
                asset.setReason(assetModel.getReason());
                this.assetService.save((Object)asset);
            }
            if (CollectionUtils.isNotEmpty(assetModel.getAssetAttachmentList())) {
                assetModel.getAssetAttachmentList().forEach(assetAttachment -> {
                    if (assetAttachment != null) {
                        if (StringUtils.isBlank((String)assetAttachment.getAttId())) {
                            assetAttachment.setAttId(UUID.hex32());
                            this.assetAttachmentService.save(assetAttachment);
                        }
                        this.assetAttachmentService.updateById(assetAttachment);
                    }
                });
            }
        }
    }
}

