/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.gtis.oa.common.utils.Constants;
import com.gtis.oa.common.utils.MapUtils;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.Schedule;
import com.gtis.oa.service.ScheduleService;
import com.gtis.oa.util.CommonUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/schedule"})
public class ScheduleController {
    @Autowired
    ScheduleService scheduleService;

    @RequestMapping(value={"schedulePage"})
    public String index(Model model) {
        model.addAttribute("userId", (Object)CommonUtil.getUserId());
        model.addAttribute("userName", (Object)CommonUtil.getUser().getAlias());
        return "management/schedule/schedule_page";
    }

    @RequestMapping(value={"/getScheduleList"})
    @ResponseBody
    public Object getScheduleList(String beginTime, String endTime, String paramStr, String colorType) throws Exception {
        HashMap<String, String> map = MapUtils.getMapFromStr((String)paramStr);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        map.put("beginTime", beginTime);
        map.put("endTime", endTime);
        List<Schedule> scheduleList = this.scheduleService.getScheduleList(map);
        String colorValue = "";
        if (colorType.equals("canEdit")) {
            colorValue = "#1883ff";
        }
        if (colorType.equals("partake")) {
            colorValue = "green";
        }
        if (colorType.equals("public")) {
            colorValue = "#e5e5e5";
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("scheduleList", scheduleList);
        resultMap.put("colorType", colorType);
        resultMap.put("colorValue", colorValue);
        resultMap.put("userId", CommonUtil.getUserId());
        resultMap.put("userName", CommonUtil.getUsername());
        return resultMap;
    }

    @RequestMapping(value={"/edit"})
    public String edit(Model model, String id, String acceptView) {
        Schedule schedule = null;
        if (StringUtils.isNotBlank((String)id)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", id);
            schedule = this.scheduleService.findByMap(map);
        }
        if (schedule == null) {
            schedule = this.scheduleService.getNewSchedule(Constants.SCHEDULE_FLAG_PERSONAL);
        }
        model.addAttribute("schedule", schedule);
        if (StringUtils.isNotBlank((String)acceptView)) {
            model.addAttribute("acceptView", (Object)acceptView);
        }
        return "management/schedule/schedule_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Schedule> save(Schedule schedule) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schedule.getId())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", schedule.getId());
            Schedule scheduleNew = this.scheduleService.findByMap(map);
            if (scheduleNew == null) {
                return new ResponseMessage<Schedule>((Boolean)this.scheduleService.save((Object)schedule), schedule);
            }
            return new ResponseMessage<Schedule>((Boolean)this.scheduleService.updateById((Object)schedule), schedule);
        }
        schedule.setId(UUID.hex32());
        return new ResponseMessage<Schedule>((Boolean)this.scheduleService.save((Object)schedule), schedule);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Schedule> delete(String[] ids) {
        return new ResponseMessage<Schedule>(this.scheduleService.removeByIds(Arrays.asList(ids)));
    }
}

