/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.model.Print;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.PrintPage;
import com.gtis.oa.service.PrintService;
import com.gtis.oa.util.CommonUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/print"})
public class PrintController {
    @Autowired
    PrintService printService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String processInsId, String view) {
        Print print = null;
        if (StringUtils.isNotBlank((String)processInsId)) {
            print = (Print)((Object)this.printService.getById((Serializable)((Object)processInsId)));
        }
        if (print == null) {
            print = new Print();
            print.setPrintId(processInsId);
            print.setApplyTime(new Date());
            print.setApplyPeople(CommonUtil.getUser().getAlias());
            print.setApplyUnit(((OrganizationDto)CommonUtil.getUser().getOrgRecordList().get(0)).getName());
            this.printService.save((Object)print);
        }
        model.addAttribute("print", (Object)print);
        model.addAttribute("view", (Object)view);
        return "officeapply/print/print_edit";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "officeapply/print/print_list";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(PrintPage printPage, long page, long limit) {
        printPage.setCurrent(page);
        printPage.setSize(limit);
        IPage<Print> printIPage = this.printService.findByPage(printPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", printIPage.getRecords());
        resultMap.put("count", printIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Print> save(Print print) {
        return new ResponseMessage<Print>((Boolean)this.printService.saveOrUpdate((Object)print), print);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Print> delete(String[] ids) {
        return new ResponseMessage<Print>(this.printService.removeByIds(Arrays.asList(ids)));
    }
}

