/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.gtis.oa.common.utils.UUID;
import com.gtis.oa.model.Laws;
import com.gtis.oa.model.ResponseMessage;
import com.gtis.oa.model.page.LawsPage;
import com.gtis.oa.service.LawsService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/laws"})
public class LawsController {
    @Autowired
    LawsService lawsService;

    @RequestMapping(value={"/index"})
    public String index(Model model, String type) {
        model.addAttribute("type", (Object)type);
        return "management/laws/laws_index";
    }

    @RequestMapping(value={"/list"})
    public String list(Model model, String treeLinkId, String treeName, String type) {
        model.addAttribute("treeLinkId", (Object)treeLinkId);
        if ("588".equals(treeLinkId)) {
            model.addAttribute("fpubDpt", (Object)treeName);
        } else if ("579".equals(treeLinkId)) {
            model.addAttribute("treeName", (Object)treeName);
        } else if ("569".equals(treeLinkId)) {
            model.addAttribute("effectLeve", (Object)treeName);
        } else if ("530".equals(treeLinkId)) {
            model.addAttribute("userArea", (Object)treeName);
        } else {
            model.addAttribute("treeName", (Object)treeName);
        }
        if ("manage".equals(type)) {
            return "management/laws/laws_list";
        }
        return "management/laws/laws_list_view";
    }

    @RequestMapping(value={"/findByPage"})
    @ResponseBody
    public Map<String, Object> findByPage(LawsPage lawsPage, HttpServletRequest request, HttpServletResponse response, long page, long limit) {
        lawsPage.setCurrent(page);
        lawsPage.setSize(limit);
        IPage<Laws> lawsIPage = this.lawsService.findByPage(lawsPage);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("data", lawsIPage.getRecords());
        resultMap.put("count", lawsIPage.getTotal());
        return resultMap;
    }

    @RequestMapping(value={"/findTempByPage"})
    @ResponseBody
    public IPage<Laws> findTempByPage(LawsPage lawsPage, HttpServletRequest request, HttpServletResponse response) {
        IPage<Laws> lawsIPage = this.lawsService.findByPage(lawsPage);
        return lawsIPage;
    }

    @RequestMapping(value={"/edit"})
    public String edit(Model model, String lawId, String treeLinkId, String treeName) {
        Laws laws = null;
        if (StringUtils.isNotBlank((String)lawId) && !"undefined".equals(lawId)) {
            laws = (Laws)((Object)this.lawsService.getById((Serializable)((Object)lawId)));
        }
        if (laws == null) {
            laws = new Laws();
            laws.setLawId(UUID.hex32());
            laws.setTreeLinkId(treeLinkId);
            laws.setTreeName(treeName);
        }
        model.addAttribute("laws", (Object)laws);
        return "management/laws/laws_edit";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ResponseMessage<Laws> save(Laws laws, HttpServletRequest request, HttpServletResponse response) {
        return new ResponseMessage<Laws>((Boolean)this.lawsService.saveOrUpdate((Object)laws), laws);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    public ResponseMessage<Laws> delete(String[] ids, HttpServletRequest request, HttpServletResponse response) {
        return new ResponseMessage<Laws>(this.lawsService.removeByIds(Arrays.asList(ids)));
    }

    @RequestMapping(value={"/showLaws"})
    public String showLaws(Model model, String lawId) {
        Laws laws = (Laws)((Object)this.lawsService.getById((Serializable)((Object)lawId)));
        model.addAttribute("laws", (Object)laws);
        return "management/laws/laws_show";
    }

    @RequestMapping(value={"/saveTreeLaws"})
    public void saveTreeLaws() {
        String url = "http://f.mnr.gov.cn/index_3553.html";
        int s = 0;
        for (int i = 1; i < 97; ++i) {
            int updataC = this.lawsService.getLawsWithUrl(url);
            System.out.print(url + (s += updataC));
            url = "http://f.mnr.gov.cn/index_3553_" + i + ".html";
        }
    }
}

