/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.oa.controller;

import cn.gtmap.gtc.storage.clients.v1.StorageClient;
import cn.gtmap.gtc.storage.domain.dto.StorageDto;
import com.gtis.oa.model.Dispatch;
import com.gtis.oa.model.Receive;
import com.gtis.oa.service.DispatchService;
import com.gtis.oa.service.ReceiveService;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/archive"})
public class ArchiveController {
    private static final Logger log = LoggerFactory.getLogger(ArchiveController.class);
    @Autowired
    StorageClient storageClient;
    @Autowired
    DispatchService dispatchService;
    @Autowired
    ReceiveService receiveService;
    private DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    @ResponseBody
    @RequestMapping(value={"/dispatch"})
    public HashMap dispatch(String[] ids, String clientId) {
        HashMap map = new HashMap();
        for (String id : ids) {
            Dispatch dispatch = null;
            dispatch = (Dispatch)((Object)this.dispatchService.getById((Serializable)((Object)id)));
            List file = null;
            ArrayList<StorageDto> files = new ArrayList<StorageDto>();
            List folders = this.storageClient.listAllRootStorages(clientId, dispatch.getDispatchId(), null, null, null, Integer.valueOf(0));
            if (folders == null || folders.isEmpty()) continue;
            for (StorageDto folder : folders) {
                file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1));
                files.add((StorageDto)file.get(0));
            }
            StringBuffer stringBuffer = this.dispatchXml(dispatch, files);
            map = this.goArchive(stringBuffer);
        }
        return map;
    }

    private StringBuffer dispatchXml(Dispatch dispatch, List<StorageDto> files) {
        String wh = dispatch.getDispatchName() + "(" + dispatch.getDispatchYear() + ")" + dispatch.getDispatchNo() + "\u53f7";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<list>\n     <archive type=\"Wsda\">");
        sb.append("<field name=\"dh\"></field>");
        sb.append("<field name=\"wh\">" + wh + "</field>");
        sb.append("<field name=\"zrz\"></field>");
        sb.append("<field name=\"jh\">" + dispatch.getDispatchNo() + "</field>");
        sb.append("<field name=\"mj\"></field>");
        sb.append("<field name=\"nd\">" + dispatch.getDispatchYear() + "</field>");
        sb.append("<field name=\"qzh\"></field>");
        sb.append("<field name=\"tm\">" + dispatch.getDispatchTitle() + "</field>");
        sb.append("<field name=\"dwdm\"></field>");
        int j = 0;
        if (files.size() > 0) {
            for (StorageDto file : files) {
                ++j;
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
            }
        }
        sb.append("</archive>");
        if (files.size() > 0) {
            for (StorageDto file : files) {
                sb.append("<doc>");
                sb.append("<field name=\"tm\">" + file.getName() + "</field>");
                sb.append("<field name=\"sxh\">" + j + "</field>");
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
                sb.append("</doc>");
                ++j;
            }
        }
        sb.append("</list>");
        return sb;
    }

    @ResponseBody
    @RequestMapping(value={"/receive"})
    public HashMap receive(String[] ids, String clientId) {
        HashMap map = new HashMap();
        for (String id : ids) {
            Receive receive = null;
            receive = (Receive)((Object)this.receiveService.getById((Serializable)((Object)id)));
            List file = null;
            ArrayList<StorageDto> files = new ArrayList<StorageDto>();
            List folders = this.storageClient.listAllRootStorages(clientId, receive.getReceiveId(), null, null, null, Integer.valueOf(0));
            if (folders == null || folders.isEmpty()) continue;
            for (StorageDto folder : folders) {
                file = this.storageClient.listAllSubsetStorages(folder.getId(), null, null, Integer.valueOf(1));
                files.add((StorageDto)file.get(0));
            }
            StringBuffer stringBuffer = this.receiveXml(receive, files);
            map = this.goArchive(stringBuffer);
        }
        return map;
    }

    private StringBuffer receiveXml(Receive receive, List<StorageDto> files) {
        String wh = receive.getReceiveName() + "(" + receive.getReceiveYear() + ")" + receive.getReceiveNo() + "\u53f7";
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<list>\n     <archive type=\"Wsda\">");
        sb.append("<field name=\"dh\"></field>");
        sb.append("<field name=\"wh\">" + wh + "</field>");
        sb.append("<field name=\"zrz\">" + receive.getFromUnit() + "</field>");
        sb.append("<field name=\"jh\">" + receive.getReceiveNo() + "</field>");
        sb.append("<field name=\"mj\"></field>");
        sb.append("<field name=\"nd\">" + receive.getReceiveYear() + "</field>");
        sb.append("<field name=\"qzh\"></field>");
        sb.append("<field name=\"tm\">" + receive.getReceiveTitle() + "</field>");
        sb.append("<field name=\"zlsj\">" + this.sdf.format(receive.getReplyDate()) + "</field>");
        sb.append("<field name=\"dwdm\"></field>");
        int j = 0;
        if (files.size() > 0) {
            for (StorageDto file : files) {
                ++j;
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
            }
        }
        sb.append("</archive>");
        if (files.size() > 0) {
            for (StorageDto file : files) {
                sb.append("<doc>");
                sb.append("<field name=\"tm\">" + file.getName() + "</field>");
                sb.append("<field name=\"sxh\">" + j + "</field>");
                sb.append("<file url=\"" + file.getDownUrl() + "\"/>");
                sb.append("</doc>");
                ++j;
            }
        }
        sb.append("</list>");
        return sb;
    }

    private HashMap goArchive(StringBuffer stringBuffer) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String msg = "";
        Boolean success = false;
        String url = "";
        HttpClient client = new HttpClient();
        PostMethod postMethod = new PostMethod(url);
        postMethod.addParameter("data", stringBuffer.toString());
        postMethod.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
        try {
            int status = client.executeMethod((HttpMethod)postMethod);
            if (200 == status) {
                success = true;
                msg = "\u5f52\u6863\u6210\u529f!";
            } else {
                msg = "\u8bf7\u68c0\u67e5" + url + "\u5f52\u6863\u7cfb\u7edf\u5730\u5740\u662f\u5426\u53ef\u7528";
            }
        }
        catch (Exception e) {
            msg = "\u5f52\u6863\u5931\u8d25" + e.getMessage();
            log.error(e.getMessage(), (Throwable)e);
        }
        map.put("msg", msg);
        map.put("success", success);
        return map;
    }
}

