<@com.html title="车辆选择列表" import="layui,layui_page,util,main,screen,xadmin,list" />
<body class="gtmap greenStyle">
<div class="gt-container gt-white" style="padding:6px 20px;">
<@toolbar show="select"/>
    <div>
        <input type="hidden" id="id" name="id" value="${id!}">
        <form class="layui-form gt-form-group">
            <div class="layui-row layui-col-space16 layui-form-item">
                <div class="layui-col-lg3">
                    <label class="layui-form-label">
                        <div class="gt-label-text">
                            车牌号:
                        </div>
                    </label>
                    <div class="layui-input-block">
                        <input type="text" name="carNo" id="carNo" lay-verify="required" placeholder="" autocomplete="off" class="layui-input">
                    </div>
                </div>
                <div class="layui-col-lg3">
                    <label class="layui-form-label">
                        <div class="gt-label-text">
                            驾驶员:
                        </div>
                    </label>
                    <div class="layui-input-block">
                        <input type="text" name="driverName" id="driverName" lay-verify="required" placeholder="" autocomplete="off" class="layui-input">
                    </div>
                </div>
                <div class="layui-col-lg3">
                    <div class="layui-input-block">
                        <div class="layui-btn" onclick="loadInfo()">搜索</div>
                    </div>
                </div>
            </div>
        </form>
    <@com.head title="车辆列表" unit="&nbsp;"/>
        <div style="border:0.3px solid #ccc;">
            <table class="layui-table">
                <colgroup>
                    <col width="3%">
                    <col width="20%">
                    <col width="15%">
                    <col width="15%">
                    <col width="15%">
                    <col width="15%">
                    <col width="17%">
                </colgroup>
                <thead >
                <tr>
                    <th>
                    </th>
                    <th>车牌号</th>
                    <th >驾驶员</th>
                    <th >车型</th>
                    <th >可容纳人数</th>
                    <th >状态</th>
                    <th >备注</th>
                </tr>
                </thead>
            </table>
        </div>

        <div style="border:0.3px solid #ccc;" class="tableContainer scroll_content">
            <table class="layui-table">
                <colgroup>
                    <col width="3%">
                    <col width="20%">
                    <col width="15%">
                    <col width="15%">
                    <col width="15%">
                    <col width="15%">
                    <col width="17%">
                </colgroup>
                <tbody id="carListTobody">
                </tbody>
            </table>
        </div>

    </div>
    <div id="pageDiv" style="border:0.1px solid #ccc;height: 41px;padding: 7px 7px 0;position: relative;margin-top: 0">

    </div>
</div>
<#--车辆选择列表 TPL-->
<script type="text/html" id="carListTpl">
    {{# for(var i = 0, len = d.records.length; i < len; i++){ }}
    <tr style="text-align: center">
        <td>
            <input name="radio" type="radio" value="{{d.records[i].carId}}" >
        </td>
        <td title="{{isNull(d.records[i].carNo)}}">
            {{isNull(d.records[i].carNo)}}
        </td>
        <td>
            {{isNull(d.records[i].driverName)}}
        </td>
        <td>
            {{isNull(d.records[i].carType)}}
        </td>
        <td>
            {{isNull(d.records[i].peopleNum)}}
        </td>
        <td>
            {{isNull(d.records[i].carCode)}}
        </td>
        <td>
            {{isNull(d.records[i].remark)}}
        </td>
    </tr>
    {{# } }}
</script>
<script type="text/javascript">
    layui.use(['form','laytpl'], function() {
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var laytpl = layui.laytpl;

        form.render();

        // 异步获取车辆列表数据
        window.loadInfo = function() {
            var index ;
            var tpl = document.getElementById('carListTpl').innerHTML; //读取模版
            $.ajax({
                type : "post",
                url : "${base}/car/findByPage",
                dataType: "json",
                data : {"current":current,"size":size,"carNo":$("#carNo").val(),"driverName":$("#driverName").val()},
                beforeSend: function () {
                    index = layer.load(1);
                },
                complete: function () {
                    layer.close(index);
                },
                success: function (data) {
                    if (typeof data == "string") {
                        data = JSON.parse(data);
                    }
                    laytpl(tpl).render(data, function (render) {
                        $("#carListTobody").html(render);
                    });
                    // 分页
                    pageFenYe(data);
                }
            });
        };

        //初始化查询
        loadInfo();

        //选择提交
        function selected() {
            var carId = $('input[name="radio"]:checked').val();
            $.ajax({
                type: "post",
                url: "${base}/usecar/saveSelectedCar",
                dataType: "json",
                data : {"id":$("#id").val(),"carId":carId},
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000}, function () {
                            $("#id").val(data.empty.id);
                        });
                    } else {
                        layer.msg(data.message, {icon: 2, time: 2000});
                    }
                    var indexUrl = "${base}/usecar/index?processInsId="+$("#id").val();
                    parent.location.href=indexUrl;
                }
            });
        };

        //选中事件
        $("#select").click(function (e) {
            selected();
        });

        //换屏自适应
        $(".tableContainer").css("height",client().height-250);
        $(window).resize(function () {
            $(".tableContainer").css("height",client().height-250);
        });
    });
</script>
</body>
