<@com.html title="加班申请单" import="layui,main,sign"/>
<body class="gtmap greenStyle">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
</style>
<div class="gt-container">
    <form class="layui-form" id="overtimeForm">
    <@toolbar show="save,print" />
    <#-- 存储隐藏值-->
        <input type="hidden" name="overtimeId" value="${overtime.overtimeId!}" id="id" >
        <div class="gt-content">
            <div class="layui-tab layui-tab-brief">
                <h3 class="text-c">加班申请单</h3>
                <h5 class="text-r">&nbsp;</h5>
                <table class="layui-table table-border">
                    <tr>
                        <td class="text-c active" style="width: 10%;">申请人</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="applyPeople" name="applyPeople" value="${overtime.applyPeople!}">
                        </td>
                        <td class="text-c active" style="width: 10%;">归属部门</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="applyUnit" name="applyUnit" value="${overtime.applyUnit!}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="width: 10%;">同加班人</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="togetherPeople" name="togetherPeople" value="${overtime.togetherPeople!}">
                        </td>
                        <td class="text-c active" style="width: 10%;">申请日期</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input layui-date"  type="text" id="applyTime" name="applyTime" value="${(overtime.applyTime!.now)?string('yyyy-MM-dd HH:mm:ss')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" >加班类型</td>
                        <td class="pd0" colspan="3">
                            <select id="overtimeType" name="overtimeType">
                                <option value="法定节日加班"<#if overtime.overtimeType?? && overtime.overtimeType=='法定节日加班'>selected </#if>>法定节日加班</option>
                                <option value="双休日值班"<#if overtime.overtimeType?? && overtime.overtimeType=='双休日值班'>selected </#if>>双休日值班</option>
                                <option value="每日安全值班"<#if overtime.overtimeType?? && overtime.overtimeType=='每日安全值班'>selected </#if>>每日安全值班</option>
                                <option value="服务承诺加班"<#if overtime.overtimeType?? && overtime.overtimeType=='服务承诺加班'>selected </#if>>服务承诺加班</option>
                                <option value="工作日加班"<#if overtime.overtimeType?? && overtime.overtimeType=='工作日加班'>selected </#if>>工作日加班</option>
                            </select>
                        </td>
                        <td class="text-c active" >加班任务性质</td>
                        <td class="pd0" colspan="3">
                            <select id="overtimeProperty" name="overtimeProperty">
                                <option value="临时新增紧急任务"<#if overtime.overtimeProperty?? && overtime.overtimeProperty=='临时新增紧急任务'>selected </#if>>临时新增紧急任务</option>
                                <option value="突击任务"<#if overtime.overtimeProperty?? && overtime.overtimeProperty=='突击任务'>selected </#if>>突击任务</option>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="width: 10%;">开始时间</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input layui-date"  type="text" id="beginTime" name="beginTime" value="${(overtime.beginTime!.now)?string('yyyy-MM-dd HH:mm:ss')}">
                        </td>
                        <td class="text-c active" style="width: 10%;">结束时间</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input layui-date"  type="text" id="endTime" name="endTime" value="${(overtime.endTime!.now)?string('yyyy-MM-dd HH:mm:ss')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">承办意见</td>
                        <td colspan="7" class="gtmapSign" signKey="cbyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">办公室意见</td>
                        <td colspan="7" class="gtmapSign" signKey="bgsyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">办公室主任</br>审批</td>
                        <td colspan="7" class="gtmapSign" signKey="bgszr" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">分管领导</br>审批</td>
                        <td colspan="7" class="gtmapSign" signKey="fgld" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">
    layui.use(['form','laydate'], function(){
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;
        //各种基于事件的操作，下面会有进一步介绍

        laydate.render({
            elem: '#applyTime', //指定元素
            type:'datetime'
            //range: true
        });
        laydate.render({
            elem: '#beginTime', //指定元素
            type:'datetime'
            //range: true
        });
        laydate.render({
            elem: '#endTime', //指定元素
            type:'datetime'
            //range: true
        });

        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });


        /**
         * 表单提交
         */
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/overtime/save",
                dataType: "json",
                data: $("#overtimeForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#id").val(data.empty.id);
                            //刷新列表
//                            opener.loadInfo();
                        });
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }

                }
            });

        }

    });

</script>
</body>