<@com.html title="会务列表" import="layui,layui_page,util,main,screen,list" />
<body class="gtmap greenStyle">
<style>
    body{
        background-color: #fff;
    }
    .gtmap .gt-container{
        top: 0px;
    }
</style>
<div class="gt-container gt-white" style="padding:6px 20px;">
<#--<@toolbar show="del"/>-->
    <div>
        <form class="layui-form gt-form-group">
            <div class="layui-row layui-col-space16 layui-form-item">
                <div class="layui-col-md3">
                    <label class="layui-form-label">
                        <div class="gt-label-text">
                            申请处室:
                        </div>
                    </label>
                    <div class="layui-input-block">
                        <input type="text" name="applyUnit" id="applyUnit" lay-verify="required" placeholder="" autocomplete="off" class="layui-input">
                    </div>
                </div>
                <div class="layui-col-md3">
                    <label class="layui-form-label">
                        <div class="gt-label-text">
                            会议主题:
                        </div>
                    </label>
                    <div class="layui-input-block">
                        <input type="text" name="theme" id="theme" lay-verify="required" placeholder="" autocomplete="off" class="layui-input">
                    </div>
                </div>
                <div class="layui-col-md3">
                    <label class="layui-form-label">
                        <div class="gt-label-text">
                            会议地点:
                        </div>
                    </label>
                    <div class="layui-input-block">
                        <input type="text" name="address" id="address" lay-verify="required" placeholder="" autocomplete="off" class="layui-input">
                    </div>
                </div>
                <div class="layui-col-md3">
                    <div class="layui-input-block">
                        <div class="layui-btn" onclick="loadInfo()">搜索</div>
                    </div>
                </div>
            </div>
        </form>
    <#if type=="view">
        <@com.head title="会务列表"/>
    </#if>
        <div style="border:0.3px solid #ccc;">
            <table class="layui-table">
                <colgroup>
                    <col width="3%">
                    <col width="25%">
                    <col width="15%">
                    <col width="15%">
                    <col width="15%">
                    <col width="10%">
                    <col width="17%">
                </colgroup>
                <thead >
                <tr>
                    <th style="text-align:center">
                        <input id="allCheckbox" type="checkbox" value="reset.less">
                    </th>
                    <th >会议主题</th>
                    <th>申请处室</th>
                    <th >时间</th>
                    <th >地点</th>
                    <th >人数</th>
                    <th >电子屏显示内容</th>
                </tr>
                </thead>
            </table>
        </div>

        <div style="border:0.3px solid #ccc;" class="tableContainer scroll_content">
            <table class="layui-table">
                <colgroup>
                    <col width="3%">
                    <col width="25%">
                    <col width="15%">
                    <col width="15%">
                    <col width="15%">
                    <col width="10%">
                    <col width="17%">
                </colgroup>
                <tbody id="meetingWorkListTobody">
                </tbody>
            </table>
        </div>

    </div>
    <div id="pageDiv" style="border:0.1px solid #ccc;height: 41px;padding: 7px 7px 0;position: relative;margin-top: 0">

    </div>
</div>
<#--会务列表 TPL-->
<script type="text/html" id="meetingWorkListTpl">
    {{# for(var i = 0, len = d.records.length; i < len; i++){ }}
    <tr style="text-align: center">
        <td>
            <input name="checkbox" type="checkbox" value="{{d.records[i].id}}" >
        </td>
        <td style="text-align: left;padding-left: 10px">
            <a title="{{isNull(d.records[i].theme)}}" href="javascript:;" onclick="toEditMeetingWork('{{d.records[i].id}}');">
                {{isNull(d.records[i].theme)}}
            </a>
        </td>
        <td>
            {{isNull(d.records[i].applyUnit)}}
        </td>
        <td>
            {{dateFormat(d.records[i].time)}}
        </td>
        <td>
            {{isNull(d.records[i].address)}}
        </td>
        <td>
            {{isNull(d.records[i].num)}}
        </td>
        <td>
            {{isNull(d.records[i].ledContent)}}
        </td>
    </tr>
    {{# } }}
</script>
<script type="text/javascript">
    layui.use(['form','laytpl'], function() {
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var laytpl = layui.laytpl;

        form.render();

        // 异步获取会务列表数据
        window.loadInfo = function() {
            var index ;
            var tpl = document.getElementById('meetingWorkListTpl').innerHTML; //读取模版
            $.ajax({
                type : "post",
                url : "${base}/meetingWork/findByPage",
                dataType: "json",
                data : {"current":current,"size":size,"applyUnit":$("#applyUnit").val(),"theme":$("#theme").val(),"address":$("#address").val()},
                beforeSend: function () {
                    index = layer.load(1);
                },
                complete: function () {
                    layer.close(index);
                },
                success: function (data) {
                    if (typeof data == "string") {
                        data = JSON.parse(data);
                    }
                    laytpl(tpl).render(data, function (render) {
                        $("#meetingWorkListTobody").html(render);
                    });
                    // 分页
                    pageFenYe(data);
                }
            });
        };


        //初始化查询
        loadInfo();

        //删除事件
        $("#del").click(function (e) {
            deleteMeetingWork();
        });

        //跳往编辑页面
        window.toEditMeetingWork = function (id) {
            window.open("${base}/meetingWork/index?processInsId="+id);
        };

        window.deleteMeetingWork = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                $("[name=checkbox]:checkbox").each(function (i, e) {
                    if ($(e).prop("checked")) {
                        ids.push($(e).val());
                    }
                });
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                        //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/meetingWork/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.01,
                            time: 2
                        })
                    },
                    complete: function () {
                        layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.alert(data.message, {icon: 6});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //换屏自适应
        $(".tableContainer").css("height",client().height-160);
        $(window).resize(function () {
            $(".tableContainer").css("height",client().height-160);
        });
    });
</script>
</body>
