<@com.html title="借款申请单" import="layui,main,sign"/>
<body class="gtmap greenStyle">
<style>
    .layui-table-cell {padding:0 !important;}
    .layui-table-cell input{border:0}
</style>
<div class="gt-container">
    <form class="layui-form" id="loanForm">
    <@toolbar show="save,print" />
    <#-- 存储隐藏值-->
        <input type="hidden" name="id" value="${loan.id!}" id="id" >
        <div class="gt-content">
            <div class="layui-tab layui-tab-brief">
                <h3 class="text-c">借款申请单</h3>
                <h5 class="text-r">&nbsp;</h5>
                <table class="layui-table table-border">
                    <tr>
                        <td class="text-c active" style="width: 10%;">借款人</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="applyPeople" name="applyPeople" value="${loan.applyPeople!}">
                        </td>
                        <td class="text-c active" style="width: 10%;">借款科室</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input" type="text" id="applyUnit" name="applyUnit" value="${loan.applyUnit!}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="width: 10%;">申请时间</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input layui-date"  type="text" id="applyTime" name="applyTime" value="${(loan.applyTime!.now)?string('yyyy-MM-dd')}">
                        </td>
                        <td class="text-c active" style="width: 10%;">拟借款时间</td>
                        <td class="pd0" colspan="3">
                            <input class="layui-input layui-date"  type="text" id="loanTime" name="loanTime" value="${(loan.loanTime!.now)?string('yyyy-MM-dd')}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px">借款原因</td>
                        <td colspan="7" class="pd0">
                            <textarea class="layui-textarea" id='purpose' name='purpose' lay-verify="content">${loan.purpose!}</textarea>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active">借款金额</td>
                        <td colspan="7" class="pd0">
                            <input class="layui-input" type="text" id="loanSum" name="loanSum" lay-verify="number" placeholder="输入借款金额（数字）" value="${loan.loanSum!}">
                            <br>
                            <input class="layui-input" type="text" id="loanSumBig" name="loanSumBig" placeholder="借款金额大写" value="${loan.loanSumBig!}">
                        </td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">承办意见</td>
                        <td colspan="7" class="gtmapSign" signKey="cbyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">办公室意见</td>
                        <td colspan="7" class="gtmapSign" signKey="bgsyj" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">办公室主任</br>审批</td>
                        <td colspan="7" class="gtmapSign" signKey="bgszr" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                    <tr>
                        <td class="text-c active" style="height: 68px!important;">分管领导</br>审批</td>
                        <td colspan="7" class="gtmapSign" signKey="fgld" noOpinion="false" multiSign="false" style="padding: 0px!important;" disabled="disabled"></td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</div>
<script type="text/javascript">
    layui.use(['form','laydate'], function(){
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var layer = layui.layer;
        var laydate = layui.laydate;
        //各种基于事件的操作，下面会有进一步介绍

        laydate.render({
            elem: '#applyTime', //指定元素
        });
        laydate.render({
            elem: '#loanTime', //指定元素
        });

        //金额校验
        form.on('input(rmb)', function(data) {
                var temp = /^\d+\.?\d{0,2}$/;
                if (temp.test(data.value)) {
                } else {
                    data.value = data.value.substr(0, data.value.length - 1);
                    // return false;
                }
            return false;
        });



        //监听提交
        form.on('submit(formSave)', function(data) {
            submit();
            return false;
        });


        /**
         * 表单提交
         */
        function submit() {
            $.ajax({
                type: "post",
                url: "${base}/loan/save",
                dataType: "json",
                data: $("#loanForm").serializeArray(),
                beforeSend: function () {
                    layer.msg('正在保存...', {
                        icon: 16,
                        shade: 0.01,
                        time: 2
                    })
                },
                complete: function () {
                    // layer.close(index);
                },
                success: function (data) {
                    if (data.flag) {
                        layer.msg(data.message, {icon: 1, time: 1000},function () {
                            $("#id").val(data.empty.id);
                            //刷新列表
//                            opener.loadInfo();
                        });
                    } else {
                        layer.msg("操作失败",{icon:2,time:2000});
                    }

                }
            });

        }

    });

</script>
</body>