<@com.html title="新闻列表" import="layui,layui_page,util,main,screen,list" />
<body class="gtmap greenStyle">
    <div class="gt-container gt-white" style="padding:6px 20px;">
        <@toolbar show="add,del"/>
        <div>
            <input type="hidden" class="input-text" id="newType" name="newType" value="${newType!}">
            <form class="layui-form gt-form-group">
                <div class="layui-row layui-col-space16 layui-form-item">
                    <div class="layui-col-md3">
                        <label class="layui-form-label">
                            <div class="gt-label-text">
                                标题:
                            </div>
                        </label>
                        <div class="layui-input-block">
                            <input type="text" name="newTitle" id="newTitle" lay-verify="required" placeholder="" autocomplete="off" class="layui-input">
                        </div>
                    </div>
                    <div class="layui-col-md3">
                        <div class="layui-input-block">
                            <div class="layui-btn" onclick="loadInfo()">搜索</div>
                        </div>
                    </div>
                </div>
            </form>
            <#--<@com.head title="新闻列表" unit="&nbsp;"/>-->
            <div style="border:0.3px solid #ccc;margin-top: 20px;">
                <table class="layui-table">
                    <colgroup>
                        <col width="3%">
                        <col width="37%">
                        <col width="15%">
                        <col width="15%">
                        <col width="15%">
                        <col width="15%">
                    </colgroup>
                    <thead>
                        <tr>
                            <th style="text-align:center">
                                <input id="allCheckbox" type="checkbox" value="reset.less">
                            </th>
                            <th >标题</th>
                            <th >作者</th>
                            <th >发布人</th>
                            <th >发布时间</th>
                            <th >新闻等级</th>
                        </tr>
                    </thead>
                </table>
            </div>
            <div style="border:0.3px solid #ccc;" class="tableContainer scroll_content">
                <table class="layui-table">
                    <colgroup>
                        <col width="3%">
                        <col width="37%">
                        <col width="15%">
                        <col width="15%">
                        <col width="15%">
                        <col width="15%">
                    </colgroup>
                    <tbody id="newsListTobody">

                    </tbody>
                </table>
            </div>


        </div>
        <div id="pageDiv" style="border:0.1px solid #ccc;height: 41px;padding: 7px 7px 0;position: relative;margin-top: 0">

        </div>
    </div>
<#--新闻列表 TPL-->
<script type="text/html" id="newsListTpl">
    {{# for(var i = 0, len = d.records.length; i < len; i++){ }}
    <tr style="text-align: center">
        <td>
            <input name="checkbox" type="checkbox" value="{{d.records[i].id}}" >
        </td>
        <td style="text-align: left;padding-left: 10px">
            <a title="{{isNull(d.records[i].newTitle)}}" href="javascript:;" onclick="index('{{d.records[i].id}}');">
                {{isNull(d.records[i].newTitle)}}
            </a>
        </td>
        <td>
            {{isNull(d.records[i].newAuthor)}}
        </td>
        <td>
            {{isNull(d.records[i].newPublisher)}}
        </td>
        <td>
            {{dateFormat(d.records[i].newUpdateDate)}}
        </td>
        <td>
            {{isNull(d.records[i].grade)}}
        </td>
    </tr>
    {{# } }}
</script>
<script type="text/javascript">
    layui.use(['form','laytpl'], function() {
        //初始化模块
        var form = layui.form;
        var $ = layui.$;
        var laytpl = layui.laytpl;

        form.render();

        // 异步获取新闻列表数据
        window.loadInfo = function() {
            var index ;
            var tpl = document.getElementById('newsListTpl').innerHTML; //读取模版
            $.ajax({
                type : "post",
                url : "${base}/news/findByPage",
                dataType: "json",
                data : {"current":current,"size":size,"newTitle":$("#newTitle").val(),"newType":$("#newType").val()},
                beforeSend: function () {
                    index = layer.load(1);
                },
                complete: function () {
                    layer.close(index);
                },
                success: function (data) {
                    if (typeof data == "string") {
                        data = JSON.parse(data);
                    }
                    laytpl(tpl).render(data, function (render) {
                        $("#newsListTobody").html(render);
                    });
                    // 分页
                    pageFenYe(data);
                }
            });
        };

        //初始化查询
        loadInfo();

        //点击事件（新增新闻）
        $("#add").click(function (e) {
            index();
        });

        //点击事件（删除新闻）
        $("#del").click(function (e) {
            deleteNews();
        });

        //跳往编辑页面
        window.index = function (id) {
            if (id==null){
                id = UUID(16,16);
            }
            window.open("${base}/news/index?id="+id+"&newType="+$("#newType").val());
        };

        window.deleteNews = function () {
            layer.confirm('您确定要删除吗？',{icon:7,btnAlign: 'c'},function (index) {
                var ids = [];
                $("[name=checkbox]:checkbox").each(function (i, e) {
                    if ($(e).prop("checked")) {
                        ids.push($(e).val());
                    }
                });
                if (ids.length == 0) {
                    layer.msg('请勾选要删除的数据', function(){
                    //关闭后的操作
                    });
                    return;
                }
                $.ajax({
                    type : "post",
                    url : "${base}/news/delete",
                    traditional: true,
                    data : {"ids" : ids},
                    beforeSend: function () {
                        layer.msg('正在删除...', {
                            icon: 16,
                            shade: 0.3,
                        })
                    },
                    complete: function () {
                        // layer.close(index);
                    },
                    success : function (data) {
                        if (data.flag) {
                            layer.alert(data.message, {icon: 6});
                            // 刷新数据
                            loadInfo();
                        } else {
                            // 失败的时候
                            layer.msg(data.message,{icon:2,time:2000});
                        }
                    }
                });
            });
        };

        //换屏自适应
        $(".tableContainer").css("height",client().height-250);
        $(window).resize(function () {
            $(".tableContainer").css("height",client().height-250);
        });
    });
</script>
</body>
